% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.mvgam.R
\name{residuals.mvgam}
\alias{residuals.mvgam}
\title{Posterior draws of residuals from \pkg{mvgam} models}
\usage{
\method{residuals}{mvgam}(object, summary = TRUE, robust = FALSE, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{An object of class \code{mvgam}}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}..}

\item{robust}{If \code{FALSE} (the default) the mean is used as
the measure of central tendency and the standard deviation as
the measure of variability. If \code{TRUE}, the median and the
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Ignored}
}
\value{
An \code{array} of randomized quantile residual values.

If \code{summary = FALSE} the output resembles those of
\code{\link{posterior_epred.mvgam}} and \code{\link{predict.mvgam}}.

If \code{summary = TRUE} the output is an \code{n_observations} x \code{E}
matrix. The number of summary statistics \code{E} is equal to \code{2 +
  length(probs)}. The \code{Estimate} column contains point estimates (either
mean or median depending on argument \code{robust}), while the
\code{Est.Error} column contains uncertainty estimates (either standard
deviation or median absolute deviation depending on argument
\code{robust}). The remaining columns starting with \code{Q} contain
quantile estimates as specified via argument \code{probs}.
}
\description{
This method extracts posterior draws of Dunn-Smyth (randomized quantile)
residuals in the order in which the data were supplied to the model. It
includes additional arguments for obtaining summaries of the computed
residuals.
}
\details{
This method gives residuals as Dunn-Smyth (randomized quantile)
residuals. Any observations that were missing (i.e. \code{NA}) in the original
data will have missing values in the residuals.
}
\examples{
\dontrun{
# Simulate some data and fit a model
simdat <- sim_mvgam(n_series = 1, trend_model = AR())

mod <- mvgam(
  y ~ s(season, bs = 'cc'),
  trend_model = AR(),
  noncentred = TRUE,
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

# Extract posterior residuals
resids <- residuals(mod)
str(resids)

# Or add them directly to the observed data, along with fitted values
augment(mod, robust = FALSE, probs = c(0.25, 0.75))
}

}
\seealso{
\code{\link{augment.mvgam}}
}
\author{
Nicholas J Clark
}
