% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_learners.R
\name{density_learners}
\alias{density_learners}
\title{Conditional Density Estimation in the \code{\{nadir\}} Package}
\description{
The following learners are available for conditional density estimation:
\itemize{
\item \code{lnr_lm_density}
\item \code{lnr_glm_density}
\item \code{lnr_homoscedastic_density}
}
}
\details{
There are a few important things to know about conditional density
estimation in the \code{nadir} package.

Firstly, conditional density
learners must produce prediction functions that predict \emph{densities}
at the new outcome values given the new covariates.

Secondly, the implemented density estimators come in two flavors:
those with a strong assumption (that of conditional normality), and those
with much weaker assumptions.  The strong assumption is encoded
into learners like \code{lnr_lm_density} and \code{lnr_glm_density}
and says "after we model the predicted mean given covariates, we expect
the remaining errors to be normally distributed." The
more flexible learners produced by \code{lnr_homoskedastic_density}
are similar in spirit, except they fit a \code{stats::density} kernel
bandwidth smoother to the error distribution (after predicting the
conditional expected mean).

A subpoint to the above point that's worth calling attention to is that
\code{lnr_homoskedastic_density} is a learner factory. That is to say,
given a \code{mean_lnr}, \code{lnr_homoskedastic_density} produces a
conditional density learner that uses that \code{mean_lnr}.

Work is ongoing on implementing a \code{lnr_heteroskedastic_density}
learner that allows for predicting higher or lower variance in the
conditional density given covariates.

Conditional density learners should be combined with the negative log loss
function when using \code{super_learner()} or using \code{compare_learners}.
Refer to the 2003 Dudoit and van der Laan paper for a starting place on the
appropriate loss functions to use for different types of outcomes.
\url{https://biostats.bepress.com/ucbbiostat/paper130/}
}
\seealso{
learners binary_learners multiclass_learners
}
\keyword{density_learners}
