% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player_season_stats.R
\name{player_season_stats}
\alias{player_season_stats}
\title{Extract player statistics from a particular team and season}
\usage{
player_season_stats(team_id, team_stats = TRUE)
}
\arguments{
\item{team_id}{Team ID determined by NCAA for season. To find ID, use
\code{\link[=find_team_id]{find_team_id()}}.}

\item{team_stats}{Logical indicating whether to include (TRUE) or exclude
(FALSE) team statistics. Default includes team statistics with player
statistics.}
}
\value{
Returns a data frame of player statistics. Note that hometown and high school
were added in 2024.
}
\description{
The NCAA's main page for a team includes a tab called "Team Statistics".
This function extracts the table of player statistics for the season, as
well as team and opponent statistics (though these can be omitted).
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
player_season_stats(team_id = "585290")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that extract player statistics: 
\code{\link{player_match_stats}()}
}
\concept{functions that extract player statistics}
