% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_extensions.R
\name{NiftiExtension}
\alias{NiftiExtension}
\title{Create a NIfTI Extension}
\usage{
NiftiExtension(ecode, data)
}
\arguments{
\item{ecode}{Integer extension code. See \code{\link{NiftiExtensionCodes}} for
known codes. Common values: 4 (AFNI), 6 (comment), 32 (CIFTI).}

\item{data}{The extension data. Can be:
\itemize{
  \item A character string (will be converted to raw with null terminator)
  \item A raw vector (used as-is)
}}
}
\value{
A \code{\link{NiftiExtension-class}} object.
}
\description{
Constructor function for creating a \code{\link{NiftiExtension-class}} object
with proper padding to ensure the size is a multiple of 16 bytes.
}
\details{
The function automatically handles padding to ensure the total extension size
(esize) is a multiple of 16 bytes, as required by the NIfTI specification.
The esize includes the 8-byte header (esize + ecode fields).
}
\examples{
# Create a comment extension
ext <- NiftiExtension(ecode = 6L, data = "This is a comment")
ext@ecode
ext@esize

# Create an AFNI extension with XML data
afni_xml <- '<?xml version="1.0"?><AFNI_attributes></AFNI_attributes>'
afni_ext <- NiftiExtension(ecode = 4L, data = afni_xml)

}
\seealso{
\code{\link{NiftiExtension-class}}, \code{\link{NiftiExtensionCodes}}
}
