% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nflfastR-package.R
\docType{package}
\name{nflfastR-package}
\alias{nflfastR}
\alias{nflfastR-package}
\title{nflfastR: Functions to Efficiently Access NFL Play by Play Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A set of functions to access National Football League play-by-play data from \url{https://www.nfl.com/}.
}
\section{Parallel Processing and Progress Updates in nflfastR}{
\subsection{Preface}{

Prior to nflfastR v4.0, parallel processing could be activated with an
argument \code{pp} in the relevant functions and progress updates were always
shown. Both of these methods are bad practice and were therefore removed
in nflfastR v4.0

The next sections describe how to make nflfastR work in parallel processes
and show progress updates if the user wants to.
}

\subsection{More Speed Using Parallel Processing}{

Nearly all nflfastR functions support parallel processing
using \code{\link[furrr:future_map]{furrr::future_map()}} if it is enabled by a call to \code{\link[future:plan]{future::plan()}}
prior to the function call.
Please see the documentation of the functions for detailed information.

As an example, the following code block will resolve all function calls in the
current session using multiple sessions in the background and load play-by-play
data for the 2018 through 2020 seasons or build them freshly for the 2018 and
2019 Super Bowls:

\if{html}{\out{<div class="sourceCode">}}\preformatted{future::plan("multisession")
load_pbp(2018:2020)
build_nflfastR_pbp(c("2018_21_NE_LA", "2019_21_SF_KC"))
}\if{html}{\out{</div>}}

We recommend choosing a default parallel processing method and saving it
as an environment variable in the R user profile to make sure all futures
will be resolved with the chosen method by default.
This can be done by following the below given steps.

First, run the following line and the file \code{.Renviron} should be opened automatically.
If you haven't saved any environment variables yet, this will be an empty file.

\if{html}{\out{<div class="sourceCode">}}\preformatted{usethis::edit_r_environ()
}\if{html}{\out{</div>}}

In the opened file \code{.Renviron} add the next line, then save the file and restart your R session.
Please note that this example sets "multisession" as default. For most users
this should be the appropriate plan but please make sure it truly is.

\if{html}{\out{<div class="sourceCode">}}\preformatted{R_FUTURE_PLAN="multisession"
}\if{html}{\out{</div>}}

After the session is freshly restarted please check if the above method worked
by running the next line. If the output is \code{FALSE} you successfully set up a
default non-sequential \code{\link[future:plan]{future::plan()}}. If the output is \code{TRUE} all functions
will behave like they were called with \code{\link[purrr:map]{purrr::map()}} and NOT in multisession.

\if{html}{\out{<div class="sourceCode">}}\preformatted{inherits(future::plan(), "sequential")
}\if{html}{\out{</div>}}

For more information on possible plans please see
\href{https://github.com/futureverse/future/blob/develop/README.md}{the future package Readme}.

For more information on \code{.Renviron} please see
\href{https://rstats.wtf/r-startup.html}{this book chapter}.
}

\subsection{Get Progress Updates while Functions are Running}{

Most nflfastR functions are able to show progress updates
using \code{\link[progressr:progressor]{progressr::progressor()}} if they are turned on before the function is
called. There are at least two basic ways to do this by either activating
progress updates globally (for the current session) with

\if{html}{\out{<div class="sourceCode">}}\preformatted{progressr::handlers(global = TRUE)
}\if{html}{\out{</div>}}

or by piping the function call into \code{\link[progressr:with_progress]{progressr::with_progress()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{load_pbp(2018:2020) |>
  progressr::with_progress()
}\if{html}{\out{</div>}}

Just like in the previous section, it is possible to activate global
progression handlers by default. This can be done by following the below given steps.

First, run the following line and the file \code{.Rprofile} should be opened automatically.
If you haven't saved any code yet, this will be an empty file.

\if{html}{\out{<div class="sourceCode">}}\preformatted{usethis::edit_r_profile()
}\if{html}{\out{</div>}}

In the opened file \code{.Rprofile} add the next line, then save the file and restart your R
session. All code in this file will be executed when a new R session starts.
The part \verb{if (require("progressr"))} makes sure this will only run if the
package progressr is installed to avoid crashing R sessions.

\if{html}{\out{<div class="sourceCode">}}\preformatted{if (requireNamespace("progressr", quietly = TRUE)) progressr::handlers(global = TRUE)
}\if{html}{\out{</div>}}

After the session is freshly restarted please check if the above method worked
by running the next line. If the output is \code{TRUE} you successfully activated
global progression handlers for all sessions.

\if{html}{\out{<div class="sourceCode">}}\preformatted{progressr::handlers(global = NA)
}\if{html}{\out{</div>}}

For more information how to work with progress handlers please see \link[progressr:progressr]{progressr::progressr}.

For more information on \code{.Rprofile} please see
\href{https://rstats.wtf/r-startup.html}{this book chapter}.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://nflfastr.com/}
  \item \url{https://github.com/nflverse/nflfastR}
  \item Report bugs at \url{https://github.com/nflverse/nflfastR/issues}
}

}
\author{
\strong{Maintainer}: Ben Baldwin \email{bbaldwin206@gmail.com}

Authors:
\itemize{
  \item Sebastian Carl \email{mrcaseb@gmail.com}
}

Other contributors:
\itemize{
  \item Lee Sharpe [contributor]
  \item Maksim Horowitz \email{maksim.horowitz@gmail.com} [contributor]
  \item Ron Yurko \email{ryurko@stat.cmu.edu} [contributor]
  \item Samuel Ventura \email{samventura22@gmail.com} [contributor]
  \item Tan Ho [contributor]
  \item John Edwards \email{edwards1860@gmail.com} [contributor]
}

}
