% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{calcMarginalLogLikImproved}
\alias{calcMarginalLogLikImproved}
\title{Calculate improved marginal log-likelihood using grid-based quadrature}
\usage{
calcMarginalLogLikImproved(summary)
}
\arguments{
\item{summary}{an approxSummary object, returned by \code{runNestedApprox}.}
}
\value{
The improved marginal log-likelihood.
}
\description{
Uses quadrature (by default AGHQ) to get an improved estimate of the marginal log-likelihood.
}
\details{
Users will not generally need to call this function directly, as it is called
automatically when sampling from the posterior of the latent nodes, since
its computation comes for free in that case.

Warning: the marginal log-likelihood is invalid for improper priors and may not be useful
for non-informative priors, because it averages the log-likelihood (approximately marginalized 
with respect to the latent nodes) over the prior distribution, thereby
including log-likelihood values corresponding to parameter values that are inconsistent with the data.
}
