% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{penaltyControl}
\alias{penaltyControl}
\title{Configure penalty settings for model evaluation}
\usage{
penaltyControl(
  penalty.value = 10000,
  step.penalties = list(rse = c(10, 10000), shrinkage = c(10, 10000), bsv = c(10, 10000),
    sigma = list(add = c(10, 10000), prop = c(10, 10000)), correlation = c(10, 10000)),
  bounds = param.bounds(),
  thresholds = list(),
  penalty.terms = c("total")
)
}
\arguments{
\item{penalty.value}{Numeric. Constant penalty assigned to binary violations
and bound constraints.}

\item{step.penalties}{A named list defining penalty magnitudes used in
step-wise procedures. Each element must contain a numeric vector of length
two representing penalty levels for moderate and critical deviations.}

\item{bounds}{A list specifying lower and upper parameter limits, as returned
by param.bounds(). The structure can include limits for theta, omega, sigma,
and correlation terms.}

\item{thresholds}{A named list describing evaluation rules for RSE and
shrinkage. Each component must include a field named method, with value
binary or step, together with the corresponding limit definition:
\itemize{
\item If method = binary: a single cutoff value stored in threshold
\item If method = step: two deviation boundaries stored in step.levels
}}

\item{penalty.terms}{Character vector specifying which components are
considered when penalties are reported. Recognized entries include:
rse, shrinkage, theta, omega, sigma, correlation, covariance, and total.
If total is included, penalties are aggregated across all components and
any other entries are ignored.}
}
\value{
A list containing the full penalty configuration for use in fitness().
}
\description{
Defines rules governing penalty assignment during model adequacy evaluation.
}
\details{
Penalization may be triggered by exceeding predefined parameter bounds
(fixed-effect and variance-covariance elements) or by surpassing thresholds
for relative standard error (RSE) or shrinkage criteria. Binary and step-wise
penalty procedures are supported.
}
\examples{
# Default configuration
penaltyControl()

# Custom bounds for selected fixed-effect parameters
penaltyControl(bounds = param.bounds(
  theta = list(lower = list(cl = 0.01, vc = 0.01))
))

# Binary penalty method for RSE
penaltyControl(thresholds = list(
  rse = list(method = "binary", threshold = 40)
))

}
\seealso{
\code{\link{param.bounds}()}, \code{\link{fitness}()}.
}
\author{
Zhonghui Huang
}
