% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.operator.R
\name{sf.operator}
\alias{sf.operator}
\title{Stepwise model building operator for model selection}
\usage{
sf.operator(
  dat,
  start.mod = NULL,
  search.space = "ivbase",
  no.cores = NULL,
  param_table = NULL,
  steps = 123567,
  dynamic_fitness = TRUE,
  penalty.control = penaltyControl(),
  precomputed_results_file = NULL,
  foldername = NULL,
  filename = "test",
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{start.mod}{A named integer vector specifying the starting model
code. If NULL, a base model is generated using \code{base_model()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{steps}{Numeric or character vector defining the sequence of steps
to be executed. Each digit corresponds to a specific step:
\describe{
\item{1}{Number of compartments}
\item{2}{Elimination type}
\item{3}{IIV on Km}
\item{4}{IIV on Ka}
\item{5}{Forward selection of structural IIV}
\item{6}{Correlation between random effects}
\item{7}{Residual error model}
}}

\item{dynamic_fitness}{Logical; if \code{TRUE}, the set of penalty terms may
change dynamically across steps.}

\item{penalty.control}{An object created by \code{penaltyControl()} defining
penalty terms used in the fitness calculation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{foldername}{Character string specifying the name of the folder to be
created in the current working directory to store intermediate results.
If NULL, a name is generated automatically.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{.modEnv}{Optional environment used internally to store model indices,
cached parameter tables, and results across steps.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to \code{mod.run()}.}
}
\value{
An object of class \code{"sfOperatorResult"} with the following elements:
\itemize{
\item \code{"Final Best Code"}: Named integer vector of the selected model code.
\item \code{"Final Best Model Name"}: Character string identifying the best model.
\item \code{"Stepwise Best Models"}: Data frame summarizing the best model
selected at each executed step.
\item \code{"Stepwise History"}: Named list containing full results for
each step using descriptive step names.
\item \code{"Model Run History"}: Data frame containing all model runs
performed during the procedure.
}
}
\description{
Implements automated stepwise model selection for structural and statistical
components of nonlinear mixed-effects models, evaluating the number of
compartments, elimination type, inter-individual variability, correlation
structures, and residual error models.
}
\details{
The stepwise procedure iterates over the specified steps in order.
At each step, only a single component of the model is modified, while
all other structural and statistical elements remain unchanged.
Model comparison is based on a scalar fitness criterion returned by
the estimation routine.

The order and inclusion of steps are controlled by the user via a
numeric step code sequence. Steps that are not applicable to the
current model configuration may be skipped automatically.

The final best model is defined as the model with the minimum fitness
value in the last completed estimation round.
}
\examples{
\donttest{
out<-sf.operator(
  dat = pheno_sd,
  steps = 1234,
  search.space = "ivbase",
  saem.control = nlmixr2est::saemControl(
    seed = 1234,
    nBurn = 200,
    nEm   = 300,
    logLik = TRUE
  )
)
print(out)
}

}
\seealso{
\code{\link{step_compartments}},
\code{\link{step_elimination}},
\code{\link{step_iiv_km}},
\code{\link{step_iiv_f}},
\code{\link{step_correlation}},
\code{\link{step_rv}}

\code{\link{auto_param_table}}, \code{\link{base_model}},
\code{\link{penaltyControl}}, \code{\link{mod.run}}, \code{\link{ppkmodGen}},
\code{\link{step_compartments}}, \code{\link{step_elimination}},
\code{\link{step_iiv_km}}, \code{\link{step_iiv_ka}}, \code{\link{step_iiv_f}},
\code{\link{step_correlation}}, \code{\link{step_rv}}
}
\author{
Zhonghui Huang
}
