np.cdf.test <-
  function(x, y = NULL,
           method = c("AD", "CVM", "KS"),
           R = 9999, parallel = FALSE, cl = NULL,
           perm.dist = TRUE, na.rm = TRUE){
    # Nonparametric Tests of Distribution Equivalence
    # Nathaniel E. Helwig (helwig@umn.edu)
    # last updated: 2026-01-15
    
    ### check x
    x <- as.matrix(x)
    nvar <- ncol(x)
    if(na.rm) x <- na.omit(x)
    
    ### check y
    if(is.null(y)){
      type <- "one.sample"
      y <- "norm"
    } else if(is.character(y)){
      type <- "one.sample"
      px <- eval(parse(text = paste0("p", y)))
      rx <- eval(parse(text = paste0("r", y)))
    } else {
      if(!(is.numeric(y) | is.matrix(y))) stop("Input 'y' must be a character, numeric, or matrix")
      type <- "two.sample"
      y <- as.matrix(y)
      if(ncol(y) != nvar) stop("Inputs 'x' and 'y' must have the same number of columns.")
      if(na.rm) y <- na.omit(y)
    } # end if(is.null(y))
    
    ### check method
    methods <- c("AD", "CVM", "KS")
    method <- as.character(method[1])
    method <- pmatch(method, methods)
    if(is.na(method)) stop("Invalid 'method' input.")
    method <- methods[method]
    
    ### one-sample or two-sample permutation test?
    if(type == "one.sample"){
      pt <- rand.test.cdf1(x = x, y = y, 
                          method = method, R = R,
                          parallel = parallel, cl = cl,
                          perm.dist = perm.dist)
      pt$nulldist <- y
      meth1 <- "One Sample"
    } else {
      pt <- rand.test.cdf2(x = x, y = y, 
                           method = method, R = R,
                           parallel = parallel, cl = cl,
                           perm.dist = perm.dist)
      meth1 <- "Two Sample"
    } # end if(type == "one.sample")
    
    ### append method
    meth2 <- ifelse(method == "AD", "Anderson-Darling",
                    ifelse(method == "CVM", "Cramer-von Mises", 
                           "Kolmogorov-Smirnov"))
    pt$method <- paste(meth1, meth2)
    
    ### return results
    class(pt) <- "np.cdf.test"
    return(pt)
    
  } # end np.cdf.test
