# GROUP RESULTS
#' @include AllGenerics.R
NULL

#' @rdname hal_group
#' @export
hal_group.HALQuery <- function(query, field, limit = 20, sort = "score",
                               decreasing = FALSE, ...) {
  ## Prevent grouping and faceting
  if (!is.null(query$facet)) query$facet <- "false"

  ## Sorting order
  how <- ifelse(isTRUE(decreasing), "desc", "asc")

  query$group <- "true"
  query$group.field <- field
  query$group.limit <- limit
  query$group.sort <- sprintf("%s %s", sort, how)
  query
}
