% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_download.R
\docType{methods}
\name{hal_download}
\alias{hal_download}
\alias{hal_download.HALQuery}
\title{Download Documents}
\usage{
hal_download(query, ...)

\method{hal_download}{HALQuery}(
  query,
  destination,
  limit = 30,
  start = 0,
  progress = getOption("odyssey.progress"),
  verbose = getOption("odyssey.verbose"),
  ...
)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{Currently not used.}

\item{destination}{A \code{\link{character}} string giving the directory path where
the downloaded files are to be saved.}

\item{limit}{An \code{\link{integer}} giving the maximum number of results.
According to HAL policy, it cannot exceed 10000.}

\item{start}{An \code{\link{integer}} specifying an absolute offset in the complete
sorted list of matches to be used as the beginning of the current page.
Only used if \code{cursor} is \code{FALSE}.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar for for the
request be printed?}

\item{verbose}{A \code{\link{logical}} scalar: should extra information be reported?}
}
\value{
Invisibly returns \code{destination}.
}
\description{
Download Documents
}
\examples{
\dontrun{
## Download the 10 most recent archaeological publication
## (if any files)
hal_query("archéologie") |>
  hal_filter("ART" \%IN\% "docType_s") |>
  hal_sort("producedDate_tdate", decreasing = TRUE) |>
  hal_download(destination = tempdir(), limit = 10)
}
}
\seealso{
Other search tools: 
\code{\link{hal_count}()},
\code{\link{hal_search}()}
}
\author{
N. Frerebeau
}
\concept{search tools}
