% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_group.R
\docType{methods}
\name{hal_group}
\alias{hal_group}
\alias{hal_group.HALQuery}
\title{Group Results}
\usage{
hal_group(query, ...)

\method{hal_group}{HALQuery}(query, field, limit = 20, sort = "score", decreasing = FALSE, ...)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{Currently not used.}

\item{field}{A \code{\link{character}} string specifying the field to group by.}

\item{limit}{An \code{\link{integer}} giving the maximum number of results per group.}

\item{sort}{A \code{\link{character}} string specifying the field to be used to sort
the results.}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort be increasing or
decreasing?}
}
\value{
An object of class \code{\link[=hal_query]{HALQuery}}.
}
\description{
Group Results
}
\examples{
\dontrun{
## Get the most recent archaeological publication (in French) by journal
hal_query("archéologie") |>
  hal_filter("ART" \%IN\% "docType_s") |>
  hal_select("producedDate_tdate", "docid") |>
  hal_sort("producedDate_tdate", decreasing = TRUE) |>
  hal_group(
    field = "journalTitle_s",
    sort = "producedDate_tdate",
    decreasing = TRUE
  ) |>
  hal_search() |>
  as.data.frame()
}
}
\seealso{
Other query tools: 
\code{\link{hal_facet}()},
\code{\link{hal_filter}()},
\code{\link{hal_query}()},
\code{\link{hal_select}()},
\code{\link{hal_sort}()},
\code{\link{operators}}
}
\author{
N. Frerebeau
}
\concept{query tools}
