% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-utils.R
\name{base64_to_image}
\alias{base64_to_image}
\title{Convert Data URIs to PNG Files}
\usage{
base64_to_image(data_uri, output_files)
}
\arguments{
\item{data_uri}{Character, a data URI character vector starting with "data:image/png;base64,"}

\item{output_files}{Character, paths to the output PNG files}
}
\value{
Character, the paths to the created PNG files
}
\description{
Decodes base64-encoded data URIs and writes them to PNG files.
}
\examples{
rlogo <- file.path(R.home("doc"), "html", "logo.jpg")
base64_str <- image_to_base64(rlogo)
base64_to_image(
  data_uri = base64_str,
  output_files = tempfile(fileext = ".jpeg")
)
}
\keyword{internal}
