% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_styles.R
\name{docx_set_paragraph_style}
\alias{docx_set_paragraph_style}
\title{Add or replace paragraph style in a Word document}
\usage{
docx_set_paragraph_style(
  x,
  style_id,
  style_name,
  base_on = "Normal",
  fp_p = fp_par(),
  fp_t = NULL
)
}
\arguments{
\item{x}{an rdocx object}

\item{style_id}{a unique style identifier for Word.}

\item{style_name}{a unique label associated with the style identifier.
This label is the name of the style when Word edit the document.}

\item{base_on}{the style name used as base style}

\item{fp_p}{paragraph formatting properties, see \code{\link[=fp_par]{fp_par()}}.}

\item{fp_t}{default text formatting properties. This is used as
text formatting properties, see \code{\link[=fp_text]{fp_text()}}. If NULL (default), the
paragraph will used the default text formatting properties (defined by
the \code{base_on} argument).}
}
\description{
The function lets you add or replace a Word paragraph style.
}
\examples{
library(officer)

doc <- read_docx()

doc <- docx_set_paragraph_style(
  doc,
  style_id = "rightaligned",
  style_name = "Explicit label",
  fp_p = fp_par(text.align = "right", padding = 20),
  fp_t = fp_text_lite(
    bold = TRUE,
    shading.color = "#FD34F0",
    color = "white")
)

doc <- body_add_par(doc,
  value = "This is a test",
  style = "Explicit label")

docx_file <- print(doc, target = tempfile(fileext = ".docx"))
docx_file
}
