% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-utils.R
\name{plot_in_png}
\alias{plot_in_png}
\title{Write a ggplot Object to PNG File}
\usage{
plot_in_png(
  ggobj = NULL,
  code = NULL,
  width,
  height,
  res = 200,
  units = "in",
  pointsize = 11,
  scaling = 1,
  path = NULL
)
}
\arguments{
\item{ggobj}{A ggplot object to render}

\item{width}{Numeric, width of the output image}

\item{height}{Numeric, height of the output image}

\item{res}{Numeric, resolution in DPI (default 200)}

\item{units}{Character, units for width and height ("in", "cm", "mm", "px") (default "in")}

\item{pointsize}{Integer, The default pointsize of the device in pt}

\item{scaling}{scaling factor to apply}

\item{path}{Character, output file path. If NULL, a temporary file is created (default NULL)}
}
\value{
Character, the path to the created PNG file
}
\description{
Renders a ggplot object to a PNG file using ragg for high-quality output.
}
\examples{
plot_in_png(
  code = {
    barplot(1:10)
  },
  width = 5,
  height = 4,
  res = 72,
  units = "in"
)
}
\keyword{internal}
