% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc_ad.R
\name{assoc_ad}
\alias{assoc_ad}
\title{Associate other data sources with AREAdata data}
\usage{
assoc_ad(
  data,
  areadata,
  targetdate = NA,
  enddate = NA,
  gid = 0,
  lonlat_names = c("Longitude", "Latitude"),
  cache_location = NULL,
  basereq = ad_basereq()
)
}
\arguments{
\item{data}{the source data to bind AREAdata to. This \strong{must} contain decimal lonlat data!}

\item{areadata}{the AREAdata to bind, usually from \code{\link[=fetch_ad]{fetch_ad()}}.}

\item{targetdate}{\strong{ONE OF} the following:
\itemize{
\item The date to search for in ISO 8601 (e.g. "2020", "2021-09", or "2022-09-21").
\item The start date for a range of dates.
\item A character vector of fully specified dates to search for (i.e. "yyyy-mm-dd").
}}

\item{enddate}{The (exclusive) end of the range of dates to search for. If this is unfilled, only the \code{targetdate} is searched for.}

\item{gid}{the spatial scale to retrieve (0 = country-level, 1=province-level...). (Note: this will preferentially use the gid level of \code{areadata} if present.)}

\item{lonlat_names}{a vector containing the column names of the longitude and latitude columns \strong{IN THAT ORDER}!}

\item{cache_location}{path to cache location (defaults to a temporary user directory, or one set by \code{\link[=set_default_ohvbd_cache]{set_default_ohvbd_cache()}}).}

\item{basereq}{the url of the AREAdata database (usually generated by \code{\link[=ad_basereq]{ad_basereq()}}). If \code{NA}, uses the default.}
}
\value{
A matrix of the \code{data} with added columns extracted from \code{areadata}.
}
\description{
Intelligently bind together data from AREAdata and other sources at a given spatial scale.
}
\section{Date ranges}{

The date range is a partially open interval. That is to say the lower bound (\code{targetdate}) is inclusive, but the upper bound (\code{enddate}) is exclusive.

For example a date range of "2020-08-04" - "2020-08-12" will return the 7 days from the 4th through to the 11th of August, but \emph{not} the 12th.
}

\section{Date inference}{


In cases where a full date is not provided, the earliest date possible with the available data is chosen.

So "2020-04" will internally become "2020-04-01".

If an incomplete date is specified as the \code{targetdate} and no \code{enddate} is specified, the range to search is inferred from the minimum temporal scale provided in \code{targetdate}.

For example "2020-04" will be taken to mean the month of April in 2020, and the \code{enddate} will internally be set to "2020-05-01".
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
vtdf <- search_hub("Aedes aegypti", "vt") |>
  tail(20) |>
  fetch() |>
  glean(cols = c(
    "DatasetID",
    "Latitude",
    "Longitude",
    "Interactor1Genus",
    "Interactor1Species"
    ), returnunique = TRUE)
areadata <- fetch_ad(metric="temp", gid=2, use_cache=TRUE)
ad_extract_working <- assoc_ad(vtdf, areadata,
                                    targetdate = c("2021-08-04"), enddate=c("2021-08-06"),
                                    gid=2, lonlat_names = c("Longitude", "Latitude"))
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{areadata}
