% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outpack_hash.R
\name{orderly_hash_file}
\alias{orderly_hash_file}
\alias{orderly_hash_data}
\title{Compute a hash}
\usage{
orderly_hash_file(path, algorithm = NULL, root = NULL)

orderly_hash_data(data, algorithm = NULL, root = NULL)
}
\arguments{
\item{path}{The name of the file to hash}

\item{algorithm}{The name of the algorithm to use, overriding that
in the orderly root.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}

\item{data}{A string to hash}
}
\value{
A string in the format \verb{<algorithm>:<digest>}
}
\description{
Use orderly's hashing functions.  This is intended for advanced
users, in particular those who want to create hashes that are
consistent with orderly from within plugins. The default
behaviour is to use the same algorithm as used in the orderly root
(via the \code{root} argument, and the usual root location
approach). However, if a string is provided for \code{algorithm} you
can use an alternative algorithm.
}
\examples{
orderly_hash_data("hello", "md5")

# If you run this function from within the working directory of an
# orderly root, then you can omit the algorithm and it will use
# the algorithm used by orderly (which will be sha256):
path <- orderly_example()
withr::with_dir(path, orderly_hash_data("hello"))
}
