% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ALD_stats.R
\name{marginal_variance}
\alias{marginal_variance}
\title{Marginal effect variance using the delta method}
\usage{
marginal_variance(ald, ref_trt = NA, comp_trt = NA, scale, family)
}
\arguments{
\item{ald}{Aggregate-level data}

\item{ref_trt}{Treatment labels reference (common; e.g. placebo)}

\item{comp_trt}{Treatment labels comparator}

\item{scale}{A scaling parameter for the calculation.}

\item{family}{A character string specifying the family distribution (e.g., "binomial").}
}
\value{
Numeric total variance of marginal treatment effects.
}
\description{
Computes the total variance of marginal treatment effects using the delta method.
}
\examples{
ald <- data.frame(trt = c("B","C","B","C"),
                  variable = c(NA, NA, "y", "y"),
                  statistic = c("N", "N", "sum", "sum"),
                  value = c(100, 100, 50, 60))
                  
marginal_variance(ald, ref_trt = "C", comp_trt = "B",
                  scale = "log_odds", family = "binomial")
}
