% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outstandR-class.R
\name{outstandR-class}
\alias{outstandR-class}
\title{outstandR class}
\description{
The \code{outstandR} class contains the results from running a
model with the function \code{\link[=outstandR]{outstandR()}}.
}
\details{
Objects of class \code{outstandR} have the following

\describe{
\item{contrasts}{A list containing statistics for relative treatment effects:
\itemize{
\item \code{means}: Estimated relative effects (e.g., log-odds ratios, risk differences).
\item \code{variances}: Variance-covariance matrix of the relative effects.
\item \code{contrast_ci}: Confidence intervals for the relative effects.
}
}
\item{absolute}{A list containing statistics for absolute treatment outcomes:
\itemize{
\item \code{means}: Estimated absolute outcomes (e.g., probabilities, mean response).
\item \code{variances}: Variance-covariance matrix of the absolute outcomes.
\item \code{ci}: Confidence intervals for the absolute outcomes.
}
}
\item{CI}{The confidence level used (e.g., 0.95).}
\item{ref_trt}{The name of the reference treatment.}
\item{scale}{The scale of the outcome (e.g., "log odds", "probability").}
\item{model}{A list containing details of the underlying statistical model.
Contents vary by strategy:
\itemize{
\item \code{family}: The error distribution and link function.
\item \code{fit}: The underlying model object (e.g., for STC, G-Comp ML, or Bayesian G-Comp).
\item \code{weights}, \code{ESS}: (MAIC only) The estimated weights and Effective Sample Size.
\item \code{stan_args}: (Bayesian G-Comp, MIM) Arguments passed to Stan.
\item \code{rho}: (G-Comp ML, MIM, Bayesian G-Comp) Correlation coefficient.
\item \code{N}: (G-Comp ML, MIM, Bayesian G-Comp) Number of iterations.
\item \code{nu}, \code{hats.v}, \code{M}: (MIM only) Imputation parameters and matrices.
}
}
}
}
