% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_surv_mod}
\alias{check_surv_mod}
\title{Check parametric survival models}
\usage{
check_surv_mod(
  df,
  surv_mod_1,
  surv_mod_2,
  v_names_param_mod_1,
  v_names_param_mod_2,
  time = seq(0, 5, 0.1),
  label_surv_1 = "first survival",
  label_surv_2 = "second survival",
  n_view = 10
)
}
\arguments{
\item{df}{a dataframe.}

\item{surv_mod_1}{character. Name of the parametric model to use for the first survival model.}

\item{surv_mod_2}{character. Name of the parametric model to use for the second survival model.}

\item{v_names_param_mod_1}{(vector of) character. Name of the columns containing the parameter values for the first survival model.}

\item{v_names_param_mod_2}{(vector of) character. Name of the columns containing the parameter values for the second survival model.}

\item{time}{a numerical vector. Determine at which time points survival probabilities have to be estimated for both survival models. For each of these time points, it will be checked whether the first survival model results in higher survival probabilities than the second survival model.}

\item{label_surv_1}{character vector. The label to provide to the first survival curve (relevant for export).}

\item{label_surv_2}{character vector. The label to provide to the second survival curve (relevant for export).}

\item{n_view}{integer. Number of iterations to mention in which the curves are crossing. Default is 10.}
}
\value{
A list. The first element is a message, the second element contains the number of the iterations in which the the first curve is higher than the second curve.
}
\description{
This function tests whether the first of two parametric survival model is lower than a second parametric survival model.
}
\details{
The parametric models that can be used are the following: exponential (\code{\link[stats:pexp]{exp}}), Weibull (\code{\link[stats:pweibull]{weibull}}), gamma (\code{\link[stats:pgamma]{gamma}}), loglogistic (\code{\link[stats:plogis]{logis}}), and lognormal (\code{\link[stats:plnorm]{lnorm}}). All these functions are implemented following their distribution function as documented in the \link[=stats]{stats} package.
}
