% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{write_model_result_csv}
\alias{write_model_result_csv}
\title{Write Model Result CSV}
\usage{
write_model_result_csv(dest_dir, name, data, model_result)
}
\arguments{
\item{dest_dir}{A character string specifying the directory where the CSV files will be saved.}

\item{name}{A character string specifying the base name for the output files.}

\item{data}{A data.table containing the intermediate data used in the model.}

\item{model_result}{A list containing the model results, including parameter values and regression data.}
}
\value{
No return value, called for side effects
}
\description{
This function exports the intermediate data table, regression data, and model parameters into separate CSV files for easy access and further analysis.
}
\details{
This function generates three CSV files:
\enumerate{
\item \strong{raw_data.csv:} Contains the original raw data used in the model.
\item \strong{regression_data.csv:} Includes the regression data with predicted electron transport rate (ETR) values.
\item \strong{model_result.csv:} Summarizes the parameter values derived from the model results (excluding regression data), such as \code{alpha} or \code{beta}.
}
The `name` parameter serves as a prefix for each file, ensuring clarity and organization in the output directory.
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#write_model_result_csv}
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- eilers_peeters_generate_regression_ETR_I(data)
write_model_result_csv(tempdir(), "20240925", data, result)

}
