// Generated by rstantools.  Do not edit by hand.

/*
    pema is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pema is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pema.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_hs_prior_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 20> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 28, column 2 to column 10)",
  " (in 'string', line 29, column 2 to column 16)",
  " (in 'string', line 30, column 2 to column 26)",
  " (in 'string', line 31, column 2 to column 24)",
  " (in 'string', line 34, column 2 to column 9)",
  " (in 'string', line 35, column 2 to column 65)",
  " (in 'string', line 39, column 2 to column 32)",
  " (in 'string', line 40, column 2 to line 41, column 15)",
  " (in 'string', line 42, column 2 to line 43, column 19)",
  " (in 'string', line 44, column 2 to column 67)",
  " (in 'string', line 20, column 2 to column 19)",
  " (in 'string', line 21, column 2 to column 26)",
  " (in 'string', line 22, column 2 to column 24)",
  " (in 'string', line 23, column 2 to column 29)",
  " (in 'string', line 24, column 2 to column 27)",
  " (in 'string', line 14, column 4 to column 34)",
  " (in 'string', line 15, column 4 to column 69)",
  " (in 'string', line 16, column 4 to column 35)",
  " (in 'string', line 13, column 57 to line 17, column 3)"};
template <typename T0__, typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__, T3__>
horseshoe(const T0__& z, const T1__& lambda, const T2__& tau, const T3__& c2,
          std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>*>
stan::promote_args_t<T0__, T1__, T2__, T3__>
horseshoe(const T0__& z, const T1__& lambda, const T2__& tau, const T3__& c2,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ lambda2 = DUMMY_VAR__;
    current_statement__ = 16;
    lambda2 = stan::math::square(lambda);
    local_scalar_t__ lambda_tilde = DUMMY_VAR__;
    current_statement__ = 17;
    lambda_tilde = stan::math::sqrt(((c2 * lambda2) / (c2 +
                     (stan::math::pow(tau, 2) * lambda2))));
    current_statement__ = 18;
    return ((z * lambda_tilde) * tau);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_hs_prior final : public model_base_crtp<model_hs_prior> {
private:
  double df;
  double df_global;
  double df_slab;
  double scale_global;
  double scale_slab;
public:
  ~model_hs_prior() {}
  model_hs_prior(stan::io::var_context& context__, unsigned int
                 random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_hs_prior_namespace::model_hs_prior";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 11;
      context__.validate_dims("data initialization", "df", "double",
        std::vector<size_t>{});
      df = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 11;
      df = context__.vals_r("df")[(1 - 1)];
      current_statement__ = 11;
      stan::math::check_greater_or_equal(function__, "df", df, 0);
      current_statement__ = 12;
      context__.validate_dims("data initialization", "df_global", "double",
        std::vector<size_t>{});
      df_global = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 12;
      df_global = context__.vals_r("df_global")[(1 - 1)];
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "df_global", df_global,
        0);
      current_statement__ = 13;
      context__.validate_dims("data initialization", "df_slab", "double",
        std::vector<size_t>{});
      df_slab = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 13;
      df_slab = context__.vals_r("df_slab")[(1 - 1)];
      current_statement__ = 13;
      stan::math::check_greater_or_equal(function__, "df_slab", df_slab, 0);
      current_statement__ = 14;
      context__.validate_dims("data initialization", "scale_global",
        "double", std::vector<size_t>{});
      scale_global = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 14;
      scale_global = context__.vals_r("scale_global")[(1 - 1)];
      current_statement__ = 14;
      stan::math::check_greater_or_equal(function__, "scale_global",
        scale_global, 0);
      current_statement__ = 15;
      context__.validate_dims("data initialization", "scale_slab", "double",
        std::vector<size_t>{});
      scale_slab = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 15;
      scale_slab = context__.vals_r("scale_slab")[(1 - 1)];
      current_statement__ = 15;
      stan::math::check_greater_or_equal(function__, "scale_slab",
        scale_slab, 0);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1 + 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_hs_prior";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_hs_prior_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ zb = DUMMY_VAR__;
      current_statement__ = 1;
      zb = in__.template read<local_scalar_t__>();
      local_scalar_t__ hs_local = DUMMY_VAR__;
      current_statement__ = 2;
      hs_local = in__.template read<local_scalar_t__>();
      local_scalar_t__ hs_global = DUMMY_VAR__;
      current_statement__ = 3;
      hs_global = in__.template read_constrain_lb<local_scalar_t__,
                    jacobian__>(0, lp__);
      local_scalar_t__ hs_slab = DUMMY_VAR__;
      current_statement__ = 4;
      hs_slab = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      local_scalar_t__ b = DUMMY_VAR__;
      current_statement__ = 6;
      b = horseshoe(zb, hs_local, hs_global, (stan::math::pow(scale_slab, 2)
            * hs_slab), pstream__);
      {
        current_statement__ = 7;
        lp_accum__.add(stan::math::std_normal_lpdf<false>(zb));
        current_statement__ = 8;
        lp_accum__.add((stan::math::student_t_lpdf<false>(hs_local, df, 0, 1)
          - stan::math::log(0.5)));
        current_statement__ = 9;
        lp_accum__.add((stan::math::student_t_lpdf<false>(hs_global,
                          df_global, 0, scale_global) - (1 *
          stan::math::log(0.5))));
        current_statement__ = 10;
        lp_accum__.add(stan::math::inv_gamma_lpdf<false>(hs_slab, (0.5 *
                         df_slab), (0.5 * df_slab)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_hs_prior_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double zb = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      zb = in__.template read<local_scalar_t__>();
      double hs_local = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      hs_local = in__.template read<local_scalar_t__>();
      double hs_global = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      hs_global = in__.template read_constrain_lb<local_scalar_t__,
                    jacobian__>(0, lp__);
      double hs_slab = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      hs_slab = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      double b = std::numeric_limits<double>::quiet_NaN();
      out__.write(zb);
      out__.write(hs_local);
      out__.write(hs_global);
      out__.write(hs_slab);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 6;
      b = horseshoe(zb, hs_local, hs_global, (stan::math::pow(scale_slab, 2)
            * hs_slab), pstream__);
      if (emit_transformed_parameters__) {
        out__.write(b);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ zb = DUMMY_VAR__;
      current_statement__ = 1;
      zb = in__.read<local_scalar_t__>();
      out__.write(zb);
      local_scalar_t__ hs_local = DUMMY_VAR__;
      current_statement__ = 2;
      hs_local = in__.read<local_scalar_t__>();
      out__.write(hs_local);
      local_scalar_t__ hs_global = DUMMY_VAR__;
      current_statement__ = 3;
      hs_global = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, hs_global);
      local_scalar_t__ hs_slab = DUMMY_VAR__;
      current_statement__ = 4;
      hs_slab = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, hs_slab);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "zb", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "hs_local",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "hs_global",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "hs_slab",
        "double", std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ zb = DUMMY_VAR__;
      current_statement__ = 1;
      zb = context__.vals_r("zb")[(1 - 1)];
      out__.write(zb);
      local_scalar_t__ hs_local = DUMMY_VAR__;
      current_statement__ = 2;
      hs_local = context__.vals_r("hs_local")[(1 - 1)];
      out__.write(hs_local);
      local_scalar_t__ hs_global = DUMMY_VAR__;
      current_statement__ = 3;
      hs_global = context__.vals_r("hs_global")[(1 - 1)];
      out__.write_free_lb(0, hs_global);
      local_scalar_t__ hs_slab = DUMMY_VAR__;
      current_statement__ = 4;
      hs_slab = context__.vals_r("hs_slab")[(1 - 1)];
      out__.write_free_lb(0, hs_slab);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"zb", "hs_local", "hs_global",
                "hs_slab"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"b"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>> temp{std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "zb");
    param_names__.emplace_back(std::string() + "hs_local");
    param_names__.emplace_back(std::string() + "hs_global");
    param_names__.emplace_back(std::string() + "hs_slab");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "b");
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "zb");
    param_names__.emplace_back(std::string() + "hs_local");
    param_names__.emplace_back(std::string() + "hs_global");
    param_names__.emplace_back(std::string() + "hs_slab");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "b");
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"zb\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_local\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_global\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_slab\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"zb\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_local\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_global\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_slab\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((1 + 1) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (1);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((1 + 1) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (1);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_hs_prior_namespace::model_hs_prior;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_hs_prior_namespace::profiles__;
}
#endif
#endif
