% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{phint_unnest}
\alias{phint_unnest}
\title{Unnest a phinterval into a data frame}
\usage{
phint_unnest(phint, hole_to = c("drop", "na"), keep_size = FALSE, key = NULL)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector to unnest.}

\item{hole_to}{\verb{["drop" / "na"]}

How to handle hole elements (phintervals with zero spans). If \code{"drop"}
(the default), holes are excluded from the output. If \code{"na"}, a row with
\code{NA} start and end times is included for each hole.}

\item{keep_size}{\verb{[TRUE / FALSE]}

Should a \code{size} column be included in the output? If \code{TRUE}, the output
includes a \code{size} column containing the number of spans in the original
phinterval element. If \code{FALSE} (the default), only \code{key}, \code{start}, and
\code{end} columns are returned.}

\item{key}{\verb{[vector / data.frame / NULL]}

An optional vector or data frame to use as the \code{key} column in the output.
If provided, must be the same length as \code{phint}. If \code{NULL} (the default),
the \code{key} column contains row indices (position in \code{phint}).

\code{key} may be any vector in the vctrs sense. See \code{\link[vctrs:vector-checks]{vctrs::obj_is_vector()}}
for details.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
\itemize{
\item \code{key}:
\itemize{
\item If \code{key = NULL}: A numeric vector identifying the index of the phinterval element
\item Otherwise: The element of \code{key} corresponding to the phinterval element
}
\item \code{start}: POSIXct start time of the span
\item \code{end}: POSIXct end time of the span
\item \code{size}: (if \code{keep_size = TRUE}) Integer count of spans in the phinterval element
}
}
\description{
\code{phint_unnest()} converts a \verb{<phinterval>} vector into a \code{\link[tibble:tibble]{tibble::tibble()}}
where each time span becomes a row.
}
\details{
\code{phint_unnest()} expands each phinterval element into its constituent time
spans, creating one row per span. The resulting data frame contains a \code{key}
column identifying which phinterval element each span came from, along with
\code{start} and \code{end} columns for the span boundaries.

For phinterval elements containing multiple disjoint spans, all spans are
included with the same \code{key} value. Scalar phinterval elements (single spans)
produce a single row.
}
\examples{
# Unnest scalar phintervals
phint <- phinterval(
  start = as.Date(c("2000-01-01", "2000-02-01")),
  end = as.Date(c("2000-01-15", "2000-02-15"))
)
phint_unnest(phint)

# Unnest multi-span phinterval
phint <- phinterval(
  start = as.Date(c("2000-01-01", "2000-03-01")),
  end = as.Date(c("2000-01-15", "2000-03-15")),
  by = 1
)
phint_unnest(phint)

# Handle holes
phint <- c(
  phinterval(as.Date("2000-01-01"), as.Date("2000-01-15")),
  hole(),
  phinterval(as.Date("2000-02-01"), as.Date("2000-02-15"))
)
phint_unnest(phint, hole_to = "drop")
phint_unnest(phint, hole_to = "na")

# Include size column
phint_unnest(phint, keep_size = TRUE, hole_to = "na")

# Use a custom `key`
phint_unnest(phint, key = c("A", "B", "C"), hole_to = "na")

}
