% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_keys.R
\name{get_pix_keys}
\alias{get_pix_keys}
\title{Get PIX Keys Stock by Participant}
\usage{
get_pix_keys(
  date,
  filter = NULL,
  columns = NULL,
  top = NULL,
  skip = NULL,
  orderby = NULL,
  verbose = TRUE
)
}
\arguments{
\item{date}{Character string in "YYYY-MM-DD" format specifying the reference
date. This parameter is \strong{required}. The API returns data for the last
day of the specified month.}

\item{filter}{OData filter expression as a character string. Examples:
\itemize{
\item \code{"NaturezaUsuario eq 'PF'"} - Filter by user type (PF or PJ)
\item \code{"TipoChave eq 'CPF'"} - Filter by key type
\item \code{"Nome eq 'BANCO DO BRASIL S.A.'"} - Filter by institution name
}}

\item{columns}{Character vector of columns to return. If NULL, returns all
columns. See "Available Columns" section.}

\item{top}{Integer; maximum number of records to return.}

\item{skip}{Integer; number of records to skip (for pagination).}

\item{orderby}{Character string specifying the column to sort by. Use
\code{"Column"} for ascending or \code{"Column desc"} for descending order.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with PIX keys data.
}
\description{
Retrieves the stock of PIX keys registered in the Directory of Transactional
Account Identifiers (DICT) at the end of each month, broken down by PIX
participant and key type.
}
\details{
The BCB PIX API requires a \code{date} parameter specifying which date's
data to retrieve. The data shows the number of PIX keys registered by each
financial institution (participant).

\strong{Note:} The API returns data for the last day of the month containing
the specified date. For example, \code{date = "2025-12-01"} returns data for
\code{2025-12-31}.
}
\section{Available Columns}{

\describe{
\item{Data}{Reference date (last day of month, YYYY-MM-DD format)}
\item{ISPB}{8-digit code identifying the financial institution}
\item{Nome}{Name of the PIX participant (financial institution)}
\item{NaturezaUsuario}{User type: PF (Individual) or PJ (Legal Entity)}
\item{TipoChave}{Key type: CPF, CNPJ, Celular, e-mail, or Aleatória}
\item{qtdChaves}{Number of registered keys}
}
}

\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get all PIX keys data for December 2025
keys <- get_pix_keys(date = "2025-12-01")

# Filter by key type and order by quantity
cpf_keys <- get_pix_keys(
  date = "2025-12-01",
  filter = "TipoChave eq 'CPF'",
  orderby = "qtdChaves desc",
  top = 100
)

# Filter by institution
bb_keys <- get_pix_keys(
  date = "2025-12-01",
  filter = "Nome eq 'BANCO DO BRASIL S.A.'"
)
}
}
