% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_compartmental_nl.R
\name{non_compartmental_nl}
\alias{non_compartmental_nl}
\title{Non-Compartmental Analysis (NCA) of Plasma Concentration-Time Data (Nonlinear Form)}
\arguments{
\item{data}{A data.frame containing plasma concentration-time data.}

\item{time_col}{Character string indicating the column name for time.}

\item{conc_col}{Character string indicating the column name for concentration.}

\item{dose}{Numeric value for the administered dose.}

\item{group_col}{Optional character string specifying a grouping variable for multiple groups.}

\item{terminal_points}{Number of last points to use for terminal phase estimation (default = 3).}

\item{plot}{Logical; if TRUE, plots concentration-time profile and terminal phase fit.}

\item{annotate}{Logical; if TRUE, annotates plot with PK parameters (only for <= 2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with kel, t1/2, AUC, CL, Vd, and R^2 for each group.}
  \item{\code{data}}{Processed data used for fitting and plotting.}
}
}
\description{
Performs non-compartmental analysis (NCA) on plasma concentration-time data,
fitting the terminal elimination phase using nonlinear regression of an exponential
decay. Computes area under the curve (AUC) using trapezoidal rule, estimates
terminal elimination rate constant (kel), half-life (t1/2), clearance (CL),
and volume of distribution (Vd).
}
\examples{
# Example I: Single-subject nonlinear non-compartmental analysis
df <- data.frame(
  time = c(0.25, 0.5, 1, 2, 4, 6, 8, 12),
  concentration = c(18.4, 16.9, 14.3, 10.9, 7.1, 4.7, 3.2, 2.0)
)
non_compartmental_nl(
  data = df,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,
  terminal_points = 3,
  plot = TRUE,
  annotate = TRUE
)

# Example II: Two-group nonlinear NCA (e.g., formulation comparison)
df_groups <- data.frame(
  time = rep(c(0.25, 0.5, 1, 2, 4, 6, 8), 2),
  concentration = c(
    17.8, 16.3, 13.9, 10.5, 6.6, 4.3, 3.0,  # Group A
    20.1, 18.7, 16.2, 12.7, 8.4, 5.9, 4.1   # Group B
  ),
  formulation = rep(c("Reference", "Test"), each = 7)
)
non_compartmental_nl(
  data = df_groups,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,
  group_col = "formulation",
  terminal_points = 3,
  plot = TRUE,
  annotate = TRUE
)

# Example III: Six-subject nonlinear NCA
df_subjects <- data.frame(
  time = rep(c(0.5, 1, 2, 4, 8, 12, 24), 6),
  concentration = c(
    15.6, 14.1, 11.7, 7.9, 4.3, 2.8, 1.4,  # S1
    14.9, 13.5, 11.1, 7.4, 4.0, 2.6, 1.3,  # S2
    16.3, 14.9, 12.4, 8.4, 4.7, 3.1, 1.6,  # S3
    15.1, 13.7, 11.3, 7.6, 4.2, 2.7, 1.3,  # S4
    14.6, 13.2, 10.8, 7.2, 3.9, 2.5, 1.2,  # S5
    16.0, 14.6, 12.0, 8.1, 4.5, 3.0, 1.5   # S6
  ),
  subject = rep(paste0("S", 1:6), each = 7)
)
non_compartmental_nl(
  data = df_subjects,
  time_col = "time",
  conc_col = "concentration",
  dose = 150,
  group_col = "subject",
  terminal_points = 4,
  plot = TRUE,
  annotate = FALSE
)
}
\references{
Gibaldi, M. & Perrier, D. (1982) <isbn:9780824710422> Pharmacokinetics, 2nd Edition. Marcel Dekker, New York.

Gabrielsson, J. & Weiner, D. (2000) <isbn:9186274929> Pharmacokinetic/Pharmacodynamic Data Analysis: Concepts and Applications, 3rd Edition, Revised and Expanded. Swedish Pharmaceutical Press, Stockholm.
}
\author{
Paul Angelo C. Manlapaz
}
