% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td50_model.R
\name{td50_model}
\alias{td50_model}
\title{Toxic Dose 50 (TD50) Pharmacodynamic Model}
\arguments{
\item{data}{A data frame containing toxicity response data.}

\item{dose_col}{Character string specifying the dose column.}

\item{response_col}{Character string specifying the binary toxicity response
(0 = no toxicity, 1 = toxic response).}

\item{group_col}{Optional character string specifying a grouping variable.}

\item{condition_col}{Optional character string specifying an experimental condition.}

\item{plot}{Logical; if TRUE, generates dose-response plots.}

\item{annotate}{Logical; if TRUE, annotates the plot with TD50, confidence
intervals, and model parameters (only if <=2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with TD50, 95% confidence intervals,
        slope, intercept, and pseudo-R2 values for each group.}
  \item{\code{data}}{The processed data used for model fitting and plotting.}
}
}
\description{
Fits quantal toxicity response data to a logistic dose-response model
to estimate the Toxic Dose 50 (TD50), defined as the dose producing
toxicity in 50% of the population.

The model uses binomial logistic regression and supports optional
grouping (e.g., sex, species, formulation) and stratification by
experimental conditions (e.g., exposure route).

In addition to TD50 estimation, the model provides the following
interpretable parameters:
\itemize{
  \item \strong{Slope}: Represents the steepness of the dose-response curve.
  A larger slope indicates a rapid increase in toxicity with small
  increases in dose (narrow tolerance or high population sensitivity),
  whereas a smaller slope reflects a more gradual response, suggesting
  greater inter-individual variability in susceptibility.

  \item \strong{Intercept}: Represents the baseline log-odds of observing
  toxicity at zero dose. A strongly negative intercept indicates minimal
  background toxicity, while a positive intercept suggests appreciable
  toxicity in the absence of administered dose, which may indicate
  experimental bias or background risk.

  \item \strong{TD50 95\% Confidence Interval}: An approximate 95% confidence
  interval for the TD50, computed using the delta method. This provides
  an uncertainty range around the estimated dose causing 50% toxicity.

  \item \strong{McFadden Pseudo-R\eqn{^2}}: A likelihood-based measure of
  model goodness-of-fit that quantifies how much better the fitted model
  explains the data compared to a null (intercept-only) model. Values
  between 0.1 and 0.2 indicate acceptable biological fit, while values
  above 0.3 suggest a strong and reliable dose-response relationship.
}

The function can generate dose-response plots with fitted curves and
annotate TD50, slope, intercept, TD50 confidence intervals, and
McFadden pseudo-R\eqn{^2}.
}
\examples{
# Example I: Single population toxicity study
df1 <- data.frame(
  dose = c(5, 10, 20, 40, 80, 160),
  toxic = c(0, 0, 0, 1, 1, 1)
)
td50_model(
  data = df1,
  dose_col = "dose",
  response_col = "toxic"
)

# Example II: Grouped analysis (Male vs Female)
df2 <- data.frame(
  dose = rep(c(5, 10, 20, 40, 80), 2),
  toxic = c(0,0,1,1,1, 0,0,0,1,1),
  sex = rep(c("Male","Female"), each = 5)
)
td50_model(
  data = df2,
  dose_col = "dose",
  response_col = "toxic",
  group_col = "sex"
)

# Example III: Grouped by formulation and exposure route
df3 <- data.frame(
  dose = rep(c(10, 25, 50, 100), 4),
  toxic = c(0,0,1,1, 0,1,1,1, 0,0,0,1, 0,0,1,1),
  formulation = rep(c("A","B"), each = 8),
  route = rep(c("Oral","IV"), each = 4, times = 2)
)
td50_model(
  data = df3,
  dose_col = "dose",
  response_col = "toxic",
  group_col = "formulation",
  condition_col = "route"
)
}
\references{
Bliss, C. I. (1935) <doi:10.1111/j.1744-7348.1935.tb07713.x> The
calculation of the dosage-mortality curve. Annals of Applied Biology, 22(1),
134–167.

Finney, D. J. (1971) <isbn:9780521080415> Probit Analysis, 3rd
Edition. Cambridge University Press, Cambridge.
}
\author{
Paul Angelo C. Manlapaz
}
