% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_compartment_iv_bolus_nl.R
\name{two_compartment_iv_bolus_nl}
\alias{two_compartment_iv_bolus_nl}
\title{Two-Compartment IV Bolus Pharmacokinetic Model (Nonlinear)}
\arguments{
\item{data}{A data frame containing plasma concentration-time data.}

\item{time_col}{Character string specifying the column name for time.}

\item{conc_col}{Character string specifying the column name for plasma concentration.}

\item{dose}{Numeric value specifying the administered IV bolus dose.}

\item{group_col}{Optional character string specifying a grouping variable
(e.g., formulation, subject).}

\item{plot}{Logical; if TRUE, generates a concentration-time plot with fitted curves.}

\item{annotate}{Logical; if TRUE, annotates the plot with PK parameters (only if <=2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with biexponential coefficients
  (A and B), alpha, beta, t_half_alpha, t_half_beta, and R^2 for each group.}
  \item{\code{data}}{Processed data used for fitting and plotting.}
}
}
\description{
Fits plasma concentration-time data to a two-compartment intravenous (IV) bolus
pharmacokinetic model. The model assumes instantaneous drug administration and
distribution between central and peripheral compartments, with first-order elimination.

Model:
C(t) = A * exp(-alpha * t) + B * exp(-beta * t)

where:
\itemize{
  \item A, B: intercept coefficients
  \item alpha: distribution rate constant (alpha > beta)
  \item beta: elimination rate constant
}
}
\examples{
# Example I: Single subject two-compartment IV bolus data
df <- data.frame(
  time = c(0.08, 0.25, 0.5, 1, 2, 4, 6, 8, 12),
  concentration = c(40.0, 30.5, 25.0, 17.5, 10.2, 6.4, 4.1, 2.8, 1.5)
)
two_compartment_iv_bolus_nl(
  data = df,
  time_col = "time",
  conc_col = "concentration",
  dose = 100
)

# Example II: Condition-dependent pharmacokinetics (e.g., physiological state)
df_cond <- data.frame(
  time = rep(c(0.25, 0.5, 1, 2, 4, 6, 8), 2),
  concentration = c(
    25.3, 22.1, 18.5, 13.2, 8.5, 5.6, 3.8,   # Condition A
    20.7, 18.0, 14.9, 11.3, 7.1, 4.7, 3.2    # Condition B
  ),
  condition = rep(c("Condition A", "Condition B"), each = 7)
)
two_compartment_iv_bolus_nl(
  data = df_cond,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,
  group_col = "condition"
)

# Example III: Multiple subjects (population-style two-compartment IV bolus pharmacokinetics)
df_subjects <- data.frame(
  time = rep(c(0.25, 0.5, 1, 2, 4, 6, 8), 5),
  concentration = c(
    26.1, 23.2, 19.6, 14.0, 9.0, 6.0, 4.0,   # Subject 1
    24.8, 21.8, 18.4, 13.3, 8.8, 5.8, 3.9,   # Subject 2
    25.5, 22.5, 19.0, 13.8, 8.7, 5.7, 3.7,   # Subject 3
    23.9, 20.9, 17.7, 12.8, 8.4, 5.5, 3.5,   # Subject 4
    24.4, 21.5, 18.0, 13.0, 8.5, 5.6, 3.6    # Subject 5
  ),
  subject = rep(paste0("S", 1:5), each = 7)
)
two_compartment_iv_bolus_nl(
  data = df_subjects,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,
  group_col = "subject"
)
}
\references{
Gibaldi, M. & Perrier, D. (1982) <isbn:9780824710422> Pharmacokinetics,
2nd Edition. Marcel Dekker, New York.

Gabrielsson, J. & Weiner, D. (2000) <isbn:9186274929> Pharmacokinetic/Pharmacodynamic
Data Analysis: Concepts and Applications, 3rd Edition, Revised and Expanded. Swedish
Pharmaceutical Press, Stockholm.
}
\author{
Paul Angelo C. Manlapaz
}
