% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{axesLabels}
\alias{axesLabels}
\title{Format axes labels.}
\usage{
axesLabels(
  xmark = TRUE,
  ymark = TRUE,
  replace = NULL,
  trim = TRUE,
  big.mark = "",
  decimal.mark = ".",
  ...
)
}
\arguments{
\item{xmark}{Logical: If set to TRUE (default), only the 
extreme values of the x-axis are returned (pretty tickmark locations). 
Alternatively, if \code{xmark} is specified as numeric vector (length larger 
than 1), the provided numeric values are polished and returned; 
if a two-element list is provided, the second element should provide the 
labels for the locations in the first element. See examples.}

\item{ymark}{Logical: If set to TRUE (default), only the 
extreme values of the y-axis are returned (pretty tickmark locations). 
Alternatively, if \code{ymark} is specified as numeric vector (length larger 
than 1), the provided numeric values are polished and returned; 
if a two-element list is provided, the second element should provide the 
labels for the locations in the first element. See examples.}

\item{replace}{Two-element list: The first element contains a vector with 
patterns to be replaced using the function \code{\link[base]{gsub}}, and the 
second element contains a vector with the replacements.}

\item{trim}{Logical: Argument to \code{\link[base]{format}}. If FALSE, 
logical, numeric and complex values are right-justified to a common width, 
if TRUE (default) the leading blanks for justification are suppressed.}

\item{big.mark}{character: Argument to \code{\link[base]{format}}, thousands 
separator. By default empty string (no separation).}

\item{decimal.mark}{character: Argument to \code{\link[base]{format}}, 
decimal symbol. By default ".".}

\item{...}{Other parameters provided to  \code{\link[base]{format}}.}
}
\value{
List with x-positions and associated string labels, and y-positions 
and associated string labels.
}
\description{
Format axes labels. Wrapper around \code{\link[base]{format}} 
and \code{\link[graphics]{axis}}.
}
\examples{
# default axes:
emptyPlot(-56, 1006)
# simplified axes:
emptyPlot(-56, 1006,
    xmark=TRUE, ymark=TRUE, las=1)
# correction of minus symbol and thousand separator:
# (results in LaTeX errors when creating PDF version of help files)
\dontrun{
emptyPlot(-56, 1006, axes=FALSE)
labs = axesLabels(big.mark=" ",
                  replace=list(old=c("-"),new=c("\U2212")) )
axis(1, at=labs$xat, labels=labs$xlab, las=1)
axis(2, at=labs$yat, labels=labs$ylab, las=1)
}
# custom axes labels:
labs2 = axesLabels(xmark=list(c(-56,-28,0), c("start", "center", "end")) )
axis(1, at=labs2$xat, labels=labs2$xlab, las=1,
    col.axis=alpha(2), col=alpha(2), lwd=2,
    line=-3)
# using other arguments for format:
labs3 = axesLabels(replace=NULL, trim=FALSE, scientific=TRUE)
axis(1, at=labs3$xat, labels=labs3$xlab, las=1,
    line=-6)

}
