% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{move_n_point}
\alias{move_n_point}
\title{Move a vector n elements forward or backward.}
\usage{
move_n_point(x, n = 1, na_value = NA)
}
\arguments{
\item{x}{A vector.}

\item{n}{Number indicating how many steps the vector should shift forward 
(N > 0) or backward (n < 0).}

\item{na_value}{The value to replace the empty cells with (e.g., the first 
or last points). Defaults to NA.}
}
\value{
A vector with the same length of \code{x}, all moved \code{n} steps.
}
\description{
Move a vector n elements forward or backward.
}
\examples{
(x <- -10:30)
prev <- move_n_point(x)
change <- x - prev
post5 <- move_n_point(x, n=-5)

emptyPlot(length(x), range(x))
lines(x)
lines(prev, col='red')
lines(post5, col='blue')

}
\seealso{
Other Utility functions: 
\code{\link{findAbsMin}()},
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{getRatioCoords}()},
\code{\link{get_palette}()},
\code{\link{group_sort}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{keepFigRatio}()},
\code{\link{list2str}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()},
\code{\link{sortGroups}()}
}
\author{
Jacolien van Rij
}
\concept{Utility functions}
