% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_probit.R
\name{summary.pmlsprobit}
\alias{summary.pmlsprobit}
\title{Summarizing Partial Maximum Likelihood Spatial Probit Models}
\usage{
\method{summary}{pmlsprobit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"pmlsprobit"}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An object of class \code{"summary.pmlsprobit"} containing:
\describe{
\item{\code{estimate}}{Matrix of estimates, standard errors, z-values, and p-values.}
\item{\code{rho}}{Estimated spatial autoregressive parameter.}
\item{\code{lambda}}{Estimated spatial error parameter.}
\item{\code{model.type}}{Type of spatial probit model fitted.}
\item{\code{loglik}}{Log-likelihood at the optimum.}
\item{\code{iteration}}{Number of iterations performed.}
\item{\code{returnCode}}{Optimizer convergence code.}
\item{\code{returnMessage}}{Message associated with the convergence code.}
\item{\code{vcov}}{Variance–covariance matrix of the parameter estimates.}
}
}
\description{
Provides a summary method for objects of class \code{"pmlsprobit"}.
}
\examples{
\donttest{
data(oldcol, package = "spdep")
dat <- COL.OLD
dat$y <- as.numeric(dat$CRIME > 35)

listw <- spdep::nb2listw(COL.nb, style = "W")

set.seed(857489)
mod <- pmlsbp(
  y ~ HOVAL + INC, data = dat, W = listw,
  model = "SAR", grouping = 7,
  na.action = na.omit, spectral = TRUE,
  iterlim = 1e5
)
summary(mod)
}


}
\seealso{
Partial maximum likelihood estimation is implemented in
\code{\link{pmlsbp}}.
}
