% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.pmrm_fit}
\alias{coef.pmrm_fit}
\title{Treatment effect parameters}
\usage{
\method{coef}{pmrm_fit}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{...}{Not used.}
}
\value{
For proportional models, a named vector of \code{theta} estimates
with one element for each active study arm.
For non-proportional models, a named matrix of \code{theta} with one
row for each active study arm and one column for each
post-baseline scheduled visit. Elements, rows, and columns are
named with arm/visit names as appropriate.
}
\description{
Extract the \code{theta} parameter
from a progression model for repeated measures.
}
\details{
See \code{vignette("models", package = "pmrm")} for details.
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  coef(fit)
}
\seealso{
Other estimates: 
\code{\link{VarCorr.pmrm_fit}()},
\code{\link{pmrm_marginals}()},
\code{\link{tidy.pmrm_fit}()},
\code{\link{vcov.pmrm_fit}()}
}
\concept{estimates}
