% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmrm_model_slowing_proportional.R
\name{pmrm_model_slowing_proportional}
\alias{pmrm_model_slowing_proportional}
\title{Fit the proportional slowing model.}
\usage{
pmrm_model_slowing_proportional(
  data,
  outcome,
  time,
  patient,
  visit,
  arm,
  covariates = ~0,
  visit_times = NULL,
  spline_knots = visit_times,
  spline_method = c("natural", "fmm"),
  reml = FALSE,
  hessian = c("divergence", "never", "always"),
  saddle = FALSE,
  control = list(eval.max = 4000L, iter.max = 4000L),
  initial_method = c("regression", "regression_control", "zero"),
  initial = NULL,
  silent = TRUE
)
}
\arguments{
\item{data}{A data frame or \code{tibble} of clinical data.}

\item{outcome}{Character string, name of the column in the data
with the numeric outcome variable on the continuous scale.
Could be a clinical measure of healthy or of disease severity.
Baseline is part of the model, so the \code{outcome} should
not already be a change from baseline.
The vector of outcomes may have missing values, either with explicit
\code{NA}s or with rows in the data missing for one or more visits.}

\item{time}{Character string, name of the column in the data
with the numeric time variable on the continuous scale.
This time is the time since enrollment/randomization of each patient.
A time value of 0 should indicate baseline.}

\item{patient}{Character string, name of the column in the data
with the patient ID.
This vector could be a numeric, integer, factor, or character vector.
\code{pmrm} automatically converts it into an unordered factor.}

\item{visit}{Character string, name of the column in the
data which indicates the study visit of each row.
This column could be a numeric, integer, factor, or character vector.
An ordered factor is highly recommended because \code{pmrm}
with levels assumed to be in chronological order.
The minimum visit must be baseline.}

\item{arm}{Character string, name of the column in the
data which indicates the study arm of each row.
This column could be a numeric, integer, factor, or character vector.
An ordered factor is highly recommended because \code{pmrm}
automatically converts \code{data[[arm]]} into an ordered factor anyway.
The minimum level is assumed to be the control arm.}

\item{covariates}{Partial right-sided formula
of concomitant terms in the model
for covariate adjustment (e.g. by age, gender, biomarker status, etc.).
Should not include main variables such as the values of
\code{outcome}, \code{time}, \code{patient}, \code{visit}, or \code{arm}.
The columns in the data referenced in the formula must not have
any missing values.

Set \code{covariates} to \code{~ 0} (default) to opt out of covariate adjustment.
The intercept term is removed from the model matrix \code{W}
whether or not the formula begins with `~ 0.}

\item{visit_times}{Numeric vector, the continuous scheduled time
of each study visit (since randomization).
If \code{NULL}, each visit time is automatically set set to the median
of the observed times at categorical visit in the data.}

\item{spline_knots}{Numeric vector of spline knots on the continuous scale,
including boundary knots.}

\item{spline_method}{Character string, spline method to use for the base model.
Must be \code{"natural"} or \code{"fmm"}.
See \code{\link[stats:splinefun]{stats::splinefun()}} for details.}

\item{reml}{\code{TRUE} to fit the model with restricted maximum likelihood
(REML), which involves integrating out fixed effects.
\code{FALSE} to use unrestricted maximum likelihood.
If \code{reml} is \code{TRUE}, then \code{hessian} is automatically set to \code{"never"}.}

\item{hessian}{Character string controlling
when to supply the Hessian matrix
of the objective function to the optimizer \code{\link[stats:nlminb]{stats::nlminb()}}.
Supplying the Hessian usually slows down optimization but may
improve convergence in some cases, particularly saddle points in the
objective function.

The \code{hessian} argument is automatically set to \code{"never"}
whenever \code{reml} is \code{TRUE}.

The \code{hessian} argument must be one of the following values:
\itemize{
\item \code{"divergence"}: first try the model
without supplying the Hessian.
Then if the model does not converge,
retry while supplying the Hessian.
\item \code{"never"}: fit the model only once and do not supply
the Hessian to \code{\link[stats:nlminb]{stats::nlminb()}}.
\item \code{"always"}: fit the model once and supply the Hessian to
\code{\link[stats:nlminb]{stats::nlminb()}}.
}}

\item{saddle}{\code{TRUE} to check if the optimization hit a saddle point,
and if it did, treat the model fit as if it diverged.
\code{FALSE} to skip this check for the sake of speed.}

\item{control}{A named list of control parameters passed directly to the
\code{control} argument of \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{initial_method}{Character string, name of the method
for computing initial values.
Ignored unless \code{initial} is \code{NULL}.
Must have one of the following values:
\itemize{
\item \code{"regression"}: sets the spline vertical distances \code{alpha}
to the fitted values at the knots of a simple linear regression
of the responses versus continuous time.
Sets all the other true model parameters to 0.
\item \code{"regression_control"}: like \code{"regression"} except we only
use the data from the control group.
Sets all the other true model parameters to 0.
\item \code{"zero"}: sets all true model parameters to 0, including \code{alpha}.
}}

\item{initial}{If \code{initial} is a named list,
then \code{pmrm} uses this list as the initial parameter
values for the optimization.
Otherwise, \code{pmrm} automatically computes the starting values
using the method given in the \code{initial_method} argument (see below).

If \code{initial} is a list, then it must have the following
named finite numeric elements conforming
to all the true parameters defined in
\code{vignette("models", package = "pmrm")}:
\itemize{
\item \code{alpha}: a vector with the same length as \code{spline_knots}.
\item \code{theta}: a vector with \code{K - 1} elements, where \code{K} is the
number of study arms.
\item \code{gamma}: a vector with \code{V} elements, where \code{V} is the
number of columns in the covariate adjustment model matrix \code{W}.
If you are unsure of \code{V}, simply fit a test model
(e.g. \code{fit <- pmrm_model_slowing_proportional(...)})
and then check \code{ncol(fit$constants$W)}.
\item \code{phi}: a vector with the same length as \code{visit_times}
(which may be different from the length of \code{spline_knots}).
\item \code{rho}: a vector with \code{J * (J - 1) / 2} elements,
where \code{J} is the length of \code{visit_times}.
}

You can generate an example of the format of this list
by fitting a test model
(e.g. \code{fit <- pmrm_model_slowing_proportional(...)})
and then extracting \code{fit$initial} or \code{fit$final}.}

\item{silent}{As \link[TMB]{MakeADFun}.}
}
\value{
A \code{pmrm} fit object of class \code{c("pmrm_fit_slowing", "pmrm_fit")}.
For details, see the "pmrm fit objects" section of this help file.
}
\description{
Fit the proportional slowing model
to a clinical dataset on a progressive disease.
}
\details{
See \code{vignette("models", package = "pmrm")} for details.
}
\section{pmrm fit objects}{

A \code{"pmrm_fit"} object is a classed list returned by modeling functions.
It has the following named elements:
\itemize{
\item \code{data}: a \code{tibble}, the input data with
the missing outcomes removed and the remaining rows
sorted by patient and visit within patient.
The data has a special \code{"pmrm_data"} class and should
not be modified by the user.
\item \code{constants}: a list of fixed quantities from the data
that the objective function uses in the optimization.
Most of these quantities are defined in the modeling and
simulation vignettes in the \code{pmrm} package.
\code{n_visits} is a positive integer vector with the number
of non-missing outcomes for each patient.
\item \code{options}: a list of low-level model-fitting options for \code{RTMB}.
\item \code{objective}: the objective function for the optimization.
Returns the minus log likelihood of the model.
The arguments are (1) a list of constants,
and (2) a list of model parameters.
Both arguments have strict formatting requirements.
For (1), see the \code{constants} element of the fitted model object.
For (2), see \code{initial} or \code{final}.
\code{model$fn} (from the \code{model} element of the fitted model object)
contains a copy of the objective function that only takes
a parameter list.
(The constants are in the closure of \code{model$fn}.)
\item \code{model}: model object returned by \code{\link[RTMB:TMB-interface]{RTMB::MakeADFun()}}
with the compiled objective function and gradient.
The elements can be supplied to an optimization routine in R
such as \code{\link[stats:nlminb]{stats::nlminb()}}.
\item \code{optimization}: the object returned by \code{\link[stats:nlminb]{stats::nlminb()}} to perform
the optimization that estimates the parameters.
\code{optimization$convergence} equals 0
if an only if the model converges.
\item \code{report}: object returned by \code{\link[RTMB:TMB-interface]{RTMB::sdreport()}} which has information
on the standard deviations of model parameters.
\item \code{initial}: a list of model parameters initial values.
Includes true parameters like \code{theta} and \code{alpha} but does not
include derived parameters like \code{beta} or \code{sigma}.
You can supply your own list of similarly formatted initial values
to the \code{initial} argument of the modeling function you choose.
\item \code{final}: a list of model parameter estimates after optimization,
but not including derived parameters like \code{beta} or \code{sigma}.
The format is exactly the same as \code{initial} (see above)
to help deal with divergent model fits.
If your model fit diverged and you want to try resume the optimization
with slightly better values, you can modify values in \code{final}
and supply the result to the \code{initial} argument of the modeling function.
\item \code{estimates}: a full list of parameter estimates, including derived
parameters
\item \code{standard_errors}: a list of parameter standard errors.
\item \code{metrics}: a list of high-level model metrics, including:
\itemize{
\item \code{n_observations}: positive integer scalar,
number of non-missing observations in the data.
\item \code{n_parameters}: positive integer scalar,
number of model parameters in the data.
Includes true parameters like \code{theta}
but excludes downstream functions
of parameters such as \code{beta}.
\item \code{log_likelihood}: numeric scalar,
the maximized log likelihood of the fitted model.
\item \code{deviance}: deviance of the fitted model,
defined here as \code{-2 * log_likelihood}.
\item \code{aic}: numeric scalar, the Akaike information
criterion of the fitted model.
\item \code{bic}: numeric scalar, the Bayesian information
criterion of the fitted model.
}
\item \code{spline}: a vectorized function that accepts continuous time \code{x}
and returns the value of the fitted spline \code{f(x | spline_knots, alpha)} at time \code{x}
given the user-specified knots \code{spline_knots} and the
maximum likelihood estimates of \code{alpha}.
Useful for diagnosing strange behavior in the fitted spline.
If the spline behaves oddly,
especially extrapolating beyond the range of the
time points, please consider adjusting
the knots \code{spline_knots} or the initial values of \code{alpha}
when refitting the model.
}
}

\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_slowing_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_slowing_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  str(fit$estimates)
  names(fit)
}
\seealso{
Other models: 
\code{\link{pmrm_model_decline_nonproportional}()},
\code{\link{pmrm_model_decline_proportional}()},
\code{\link{pmrm_model_slowing_nonproportional}()}
}
\concept{models}
