% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper-brms-inla-power.R
\name{brms_inla_power_parallel}
\alias{brms_inla_power_parallel}
\title{Parallel wrapper for fixed-design Bayesian power / assurance simulations}
\usage{
brms_inla_power_parallel(
  design = c("fixed"),
  sample_sizes,
  effect_grid,
  nsims,
  n_cores = max(1L, parallel::detectCores() - 1L),
  seed = 123L,
  progress = c("auto", "text", "none"),
  ...
)
}
\arguments{
\item{design}{Character scalar. Currently only "fixed" is supported.}

\item{sample_sizes}{Numeric vector of sample sizes (required).}

\item{effect_grid}{Numeric vector or data frame defining effect scenarios
(required).}

\item{nsims}{Integer number of simulations per cell.}

\item{n_cores}{Integer number of worker processes. Default is
max(1L, parallel::detectCores() - 1L).}

\item{seed}{Integer base seed. Each cell uses seed + cell_id.}

\item{progress}{Logical or character; controls wrapper-level progress bar.}

\item{...}{Further arguments passed directly to brms_inla_power(), such as
formula, family, priors, effect_name, compute_bayes_factor, bf_method,
inla_hyper, inla_num_threads, etc.}
}
\value{
A list with components summary, results, and settings.
}
\description{
Parallelises over cells defined by sample_sizes x effect_grid for the
fixed-n engine brms_inla_power().
}
