#' 
#' Poverty Probability Index (PPI) lookup table for Mozambique
#' 
#' This PPI was created in April 2019 using Mozambique’s 2014/15 Inquérito Sobre
#' Orçamento Familiar Survey and was released in May 2019.
#'
#' @format A data frame with 15 columns and 101 rows:
#' \describe{
#' \item{\code{score}}{PPI score}
#' \item{\code{nl100}}{National poverty line (100)}
#' \item{\code{nl150}}{National poverty line (150)}
#' \item{\code{nl200}}{National poverty line (200)}
#' \item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
#' \item{\code{ppp320}}{Below $3.20 per day purchasing power parity (2011)}
#' \item{\code{ppp550}}{Below $5.50 per day purchasing power parity (2011)}
#' \item{\code{ppp800}}{Below $8.00 per day purchasing power parity (2011)}
#' \item{\code{ppp1100}}{Below $11.00 per day purchasing power parity (2011)}
#' \item{\code{ppp1500}}{Below $15.00 per day purchasing power parity (2011)}
#' \item{\code{ppp2170}}{Below $21.70 per day purchasing power parity (2011)}
#' \item{\code{percentile20}}{Below 20th percentile poverty line}
#' \item{\code{percentile40}}{Below 40th percentile poverty line}
#' \item{\code{percentile60}}{Below 50th percentile poverty line}
#' \item{\code{percentile80}}{Below 60th percentile poverty line}
#' }
#'
#' @examples
#'   # Access Mozambique PPI table
#'   ppiMOZ2019
#'
#'   # Given a specific PPI score (from 0 - 100), get the row of poverty
#'   # probabilities from PPI table it corresponds to
#'   ppiScore <- 50
#'   ppiMOZ2019[ppiMOZ2019$score == ppiScore, ]
#'
#'   # Use subset() function to get the row of poverty probabilities corresponding
#'   # to specific PPI score
#'   ppiScore <- 50
#'   subset(ppiMOZ2019, score == ppiScore)
#'
#'   # Given a specific PPI score (from 0 - 100), get a poverty probability
#'   # based on a specific poverty definition. In this example, the national
#'   # poverty line is used
#'   ppiScore <- 50
#'   ppiMOZ2019[ppiMOZ2019$score == ppiScore, "nl100"]
#'
#' @source \url{https://www.povertyindex.org}
#'
"ppiMOZ2019"


#' 
#' Poverty Probability Index (PPI) lookup table for Mozambique
#' 
#' The latest version of the PPI for Mozambique was created in June 2024 by
#' Innovations for Poverty Action (IPA) based on data from the 2022 Demographic
#' and Health Survey (DHS).
#'
#' @format A data frame with 6 columns and 101 rows:
#' \describe{
#'   \item{\code{score}}{PPI score}
#'   \item{\code{percentile20}}{Below 20th percentile poverty line}
#'   \item{\code{percentile40}}{Below 40th percentile poverty line}
#'   \item{\code{percentile50}}{Below 50th percentile poverty line}
#'   \item{\code{percentile60}}{Below 60th percentile poverty line}
#'   \item{\code{percentile80}}{Below 80th percentile poverty line}
#' }
#'
#' @examples
#'   # Access Mozambique PPI table
#'   ppiMOZ2024
#'
#'   # Given a specific PPI score (from 0 - 100), get the row of poverty
#'   # probabilities from PPI table it corresponds to
#'   ppiScore <- 50
#'   ppiMOZ2024[ppiMOZ2024$score == ppiScore, ]
#'
#'   # Use subset() function to get the row of poverty probabilities
#'   # corresponding to specific PPI score
#'   ppiScore <- 50
#'   subset(ppiMOZ2024, score == ppiScore)
#'
#'   # Given a specific PPI score (from 0 - 100), get a poverty probability
#'   # based on a specific poverty definition. In this example, the national
#'   # poverty line is used
#'   ppiScore <- 50
#'   ppiMOZ2024[ppiMOZ2024$score == ppiScore, "percentile80"]
#'
#' @source \url{https://www.povertyindex.org}
#'
"ppiMOZ2024"
