% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SM_output.linear_cre.R
\name{SM_output.linear_cre}
\alias{SM_output.linear_cre}
\title{Calculate direct/indirect standardized differences from a fitted \code{linear_cre} object}
\usage{
\method{SM_output}{linear_cre}(fit, parm, stdz = "indirect", ...)
}
\arguments{
\item{fit}{a model fitted from \code{linear_cre}.}

\item{parm}{specifies a subset of providers for which confidence intervals are to be given.
By default, all providers are included. The class of \code{parm} should match the class of the provider IDs.}

\item{stdz}{a character string or a vector specifying the standardization method(s).
The possible values are:
\itemize{
\item{\code{"indirect"}} (default) indirect standardization method.
\item{\code{"direct"}} direct standardization method.
\item{\code{c("indirect", "direct")}} outputs both direct and indirect standardized measures.
}}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A list containing the standardized differences based on the method(s) specified in \code{stdz},
as well as the observed and expected outcomes used to calculate the standardized measures:
\item{indirect.difference}{indirect standardized differences, if \code{stdz} includes \code{"indirect"}.}
\item{direct.difference}{direct standardized differences, if \code{stdz} includes \code{"direct"}.}
\item{OE}{a list of data frames containing the observed and expected outcomes used for calculating standardized measures.}
}
\description{
Provide direct/indirect standardized differences for a correlated random effect linear model.
}
\details{
This function computes standardized differences for a random effect linear model
using either direct or indirect methods, or both when specified.
The function returns both the standardized differences and the observed and expected outcomes
used for their calculation.
}
\examples{
data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
data <- data.frame(outcome, ProvID, covar)
outcome.char <- colnames(data)[1]
ProvID.char <- colnames(data)[2]
wb.char <- c("z1", "z2")
other.char <- c("z3", "z4", "z5")
fit_cre <- linear_cre(data = data, Y.char = outcome.char, ProvID.char = ProvID.char,
wb.char = wb.char, other.char = other.char)
SM_output(fit_cre)

}
