% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpmSurv.R
\name{fpmSurv}
\alias{fpmSurv}
\title{Generate a survival function from a flexible parametric model}
\usage{
fpmSurv(CFM, beta = NULL, lp = NULL, maxTime = 24)
}
\arguments{
\item{CFM}{a Counter-Factual model}

\item{beta}{parameter with which to adjust the baseline function (defaults to
beta=0)}

\item{lp}{a linear predictor which if supplies will be used to adjust the
parameters of the survival function}

\item{maxTime}{maximum time used in the estimation}
}
\value{
A survival function
}
\description{
A function to estimate the survival function based on parameter estimates.
}
\details{
This functions extracts the baseline (cumulative) hazard parameters from a
counter factual model and uses these to construct survival estimates.  This
is used in the simulation of datasets.  If a (log) hazard ratio, beta, or a
linear predictor, lp, are supplied - these will be used to adjust the
baseline estimates.
}
