% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_plot_psdr.R
\name{plot.psdr}
\alias{plot.psdr}
\title{Plot sufficient predictors from a psdr object}
\usage{
\method{plot}{psdr}(
  x,
  ...,
  d = 1,
  lowess = TRUE,
  col = NULL,
  line.col = "red",
  pch = 16,
  lwd = 1.2,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{x}{object from the function \code{psdr()}}

\item{...}{Additional graphical parameters passed to \code{plot()}.}

\item{d}{number of sufficient predictors. Default is 1.}

\item{lowess}{draw a locally weighted scatterplot smoothing curve. Default is TRUE.}

\item{col}{color vector for points (optional; defaults depend on response type)}

\item{line.col}{color for lowess smoothing line (default = "red")}

\item{pch}{plotting character (default = 16)}

\item{lwd}{line width for smoothing curve (default = 1.2)}

\item{xlab}{label for x-axis (default depends on d)}

\item{ylab}{label for y-axis (default depends on response type)}
}
\value{
A scatter plot with sufficient predictors and the lowess curve is overlayed as default.
}
\description{
Produces scatter plots of the sufficient predictors obtained from psdr().
For continuous responses, the function plots Y versus each selected
sufficient predictor along with an optional lowess curve. For binary
responses, a two-dimensional scatter plot of the first two sufficient
predictors is produced with class-specific point colors.

Additional graphical parameters may be passed to the underlying plot()
function. The plot is intended as a diagnostic tool to visualize the
estimated central subspace and assess how well the sufficient predictors
capture the relationship between X and Y.
}
\examples{
\donttest{
set.seed(1)
n <- 200; p <- 5;
x <- matrix(rnorm(n*p, 0, 2), n, p)
y <-  x[,1]/(0.5 + (x[,2] + 1)^2) + 0.2*rnorm(n)
obj <- psdr(x, y)
plot(obj)
}
}
\seealso{
\code{\link{psdr_bic}}, \code{\link{psdr}}
}
\author{
Jungmin Shin, \email{c16267@gmail.com}, Seung Jun Shin, \email{sjshin@korea.ac.kr}, Andreas Artemiou \email{artemiou@uol.ac.cy}
}
