% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization-utils.R
\name{interaction_line_plot}
\alias{interaction_line_plot}
\title{Make a interaction line plot}
\usage{
interaction_line_plot(y, x, by, data, ylim = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{y}{A continuous variable to be plotted along the y-axis}

\item{x}{A continuous variable to be plotted along the x-axis}

\item{by}{A categorical variable by which we split the data and create one line plot for each resulting group}

\item{data}{A data frame with the \code{x}, \code{y}, \code{by} variables}

\item{ylim}{A vector of limits for the y-axis}

\item{xlab}{The label of the x-axis (defaults to the \code{x} variable name).}

\item{ylab}{The label of the y-axis (defaults to the \code{y} variable name).}
}
\value{
A \code{ggplot2::ggplot} object, which may be modified with further \code{ggplot2}
commands.
}
\description{
Make a interaction line plot
}
\examples{
interaction_line_plot(y = score, x = time, by = treatment, 
                      data = selfesteem2_long, ylim = c(70, 100))
interaction_line_plot(y = score, x = time, by = treatment, 
                      data = selfesteem2_long, 
                      xlab = 'measurement time',
                      ylab = 'self esteem score',
                      ylim = c(70, 100))
}
