% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychiatric.R
\docType{data}
\name{psychiatric}
\alias{psychiatric}
\title{Psychiatric History}
\format{
A tibble with 3,560 rows and
16 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{has_schizophrenia}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Medical and psychiatric history interview indicates schizophrenia \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_major_dep}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Medical and psychiatric history interview indicates major depression \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_bipolar}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Medical and psychiatric history interview indicates bipolar disorder \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_anx_pan}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Medical and psychiatric history interview indicates anxiety panic disorder \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_brain_damage}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Medical and psychiatric history interview indicates brain damage \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_epilepsy}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Medical and psychiatric history interview indicates epilepsy \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{depression}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Yes) \cr
    \tab  \cr
   \emph{Description:} \tab Addiction Severity Index-Lite Follow-up depression: P4 = "Experienced serious depression-sadness, hopelessness, loss of interest, difficulty with daily function?" See the Details section below \cr
    \tab  \cr
   \emph{Levels:} \tab Yes, No, Not answered, Missing, \cr
}


}
\item{\strong{anxiety}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Yes) \cr
    \tab  \cr
   \emph{Description:} \tab Addiction Severity Index-Lite Follow-up anxiety: P5 = "Experienced serious anxiety/tension, uptight, unreasonably worried, inability to feel relaxed?" See the Details section below \cr
    \tab  \cr
   \emph{Levels:} \tab Yes, No, Not answered, Missing, \cr
}


}
\item{\strong{schizophrenia}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Yes) \cr
    \tab  \cr
   \emph{Description:} \tab Addiction Severity Index-Lite Follow-up schizophrenia P6 = "Experienced hallucinations -- saw things or heard voices that other people did not hear or see?" See the Details section below \cr
    \tab  \cr
   \emph{Levels:} \tab Yes, No, Not answered, Missing, \cr
}


}
\item{\strong{has_opiates_dx}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab DSM-4 opioid abuse or dependence diagnosis or DSM-5 "opioid use disorder" (OUD) diagnosis \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_alcol_dx}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab DSM-4 alcohol abuse or dependence diagnosis or DSM-5 "alcohol use disorder" (AUD) diagnosis \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_amphetamines_dx}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab DSM-4 amphetamine and similar sympathomimetics abuse or dependence diagnosis or DSM-5 amphetamine-type substance use disorder \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_cannabis_dx}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab DSM-4 cannabis abuse or dependence diagnosis or DSM-5 cannabis use disorder \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_cocaine_dx}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab DSM-4 cocaine abuse or dependence diagnosis or DSM-5 cocaine use disorder \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{has_sedatives_dx}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab DSM-4 sedatives abuse or dependence diagnosis or DSM-5 sedative hypnotic/anxiolytic use disorder \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
}
}
\source{
\doi{10.1001/jama.1994.03520100096046} DSM-IV: Diagnostic and Statistical Manual of Mental Disorders, JAMA. 1994;272(10):828-829.

\doi{10.1176/appi.books.9780890425596} Diagnostic and Statistical Manual of Mental Disorders (Fifth ed.). Arlington, VA: American Psychiatric Publishing. ISBN 978-0-89042-555-8.
}
\usage{
data(psychiatric)
}
\description{
Information on psychiatric symptoms and diagnoses. The same
constructs were measured using different instruments. For example, the
Addition Severity Index (ASI) asks "Have you had a significant period of
time (that was not a direct result of drug/alcohol use) in which you have
experienced hallucinations - saw things or heard voices that other people
did not hear or see?" and the medical and psychiatric history evaluation
asks about schizophrenia. The definitions of substance abuse have changed
in the American Psychiatric Association's Diagnostic and Statistical Manual
of Mental Disorders. Also see the
\href{../doc/harmonization.html#psychiatric}{Harmonization Information} vignette
for more details.
}
\details{
Note that the data from the ASI (depression, anxiety, and
schizophrenia) contains four levels plus \code{NA}.  People who did not take the
ASI are coded with NA.  People who took the ASI but are completely missing
an answer to a question are coded as "Missing". Others who are known to not
answer (i.e., refused to answer) are coded with "Not Answered".
}
\keyword{datasets}
