% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_master.R
\name{build_master}
\alias{build_master}
\title{Build a Master Script From Folder}
\usage{
build_master(
  dir,
  master_name = "Master",
  with_structure = TRUE,
  with_run_all = TRUE,
  with_run_folder = TRUE
)
}
\arguments{
\item{dir}{The folder structure which contains the scripts to build upon.}

\item{master_name}{The file name which should be written.}

\item{with_structure}{Whether the folder structure as tree should be written
to the master script.}

\item{with_run_all}{Whether a section, which let's the user run all scripts,
should be written to the master script.}

\item{with_run_folder}{Whether a section, which let's the user run all scripts from a
specific folder, should be written to the master script.}
}
\value{
Returns the script as character vector and saves it as markdown file.
}
\description{
\code{\link[=build_master]{build_master()}} reads a given folder structure, which contains scripts, and builds
a master script as a markdown file.
}
\details{
The function works with folder structures that look like this:

root/

\if{html}{\out{<div class="sourceCode">}}\preformatted{ subfolder1/

     script1.R

     script2.R

     ....R

 subfolder2/

     script3.R

     script4.R

     ....R

 .../

     ....R
}\if{html}{\out{</div>}}
}
\examples{
build_master(dir = "C:/My Projects/Code", master_name = "Master Script")

}
