% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.phenos.R
\name{add.phenos}
\alias{add.phenos}
\title{Add phenotypes to cross object.}
\usage{
add.phenos(cross, newdata = NULL, index = NULL)
}
\arguments{
\item{cross}{object of class \code{cross}; see \code{\link[qtl]{read.cross}}}

\item{newdata}{data frame with row names matching values of phenotype
identified by \code{index} for object \code{cross}}

\item{index}{character string name of phenotype in object \code{cross}; if
\code{NULL}, then \code{newdata} must be of same size as \code{cross} with
phenotypes in order}
}
\value{
object of class \code{cross} with added phenotypes
}
\description{
Add phenotypes to cross object by checking index.
}
\details{
The name \code{index} must be a phenotype in the \code{cross} object. The
row names of \code{newdata} are matched with values of \code{index}.
}
\examples{

\dontrun{
data(hyper)
x <- data.frame(x = rnorm(nind(hyper)))
hyperx <- add.phenos(hyper, x)
}

}
\seealso{
\code{\link[qtl]{read.cross}}
}
\author{
Brian S. Yandell, \email{byandell@wisc.edu}
}
\keyword{utilities}
