% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quallmer-package.R
\docType{package}
\name{quallmer-package}
\alias{quallmer}
\alias{quallmer-package}
\title{quallmer: Qualitative Analysis with Large Language Models}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Tools for AI-assisted qualitative data coding using large language models ('LLMs') via the 'ellmer' package, supporting providers including 'OpenAI', 'Anthropic', 'Google', 'Azure', and local models via 'Ollama'. Provides a 'codebook'-based workflow for defining coding instructions and applying them to texts, images, and other data. Includes built-in 'codebooks' for common applications such as sentiment analysis and policy coding, and functions for creating custom 'codebooks' for specific research questions. Supports systematic replication across models and settings, computing inter-coder reliability statistics including Krippendorff's alpha (Krippendorff 2019, \doi{10.4135/9781071878781}) and Fleiss' kappa (Fleiss 1971, \doi{10.1037/h0031619}), as well as gold-standard validation metrics including accuracy, precision, recall, and F1 scores following Sokolova and Lapalme (2009, \doi{10.1016/j.ipm.2009.03.002}). Provides audit trail functionality for documenting coding workflows following Lincoln and Guba's (1985, ISBN:0803924313) framework for establishing trustworthiness in qualitative research.
}
\references{
Krippendorff, K. (2019). Content Analysis: An Introduction to Its
Methodology. 4th ed. Thousand Oaks, CA: SAGE. \doi{10.4135/9781071878781}

Fleiss, J. L. (1971). Measuring nominal scale agreement among many raters.
Psychological Bulletin, 76(5), 378–382. \doi{10.1037/h0031619}

Cohen, J. (1960). A coefficient of agreement for nominal scales. Educational
and Psychological Measurement, 20(1), 37–46. \doi{10.1177/001316446002000104}

Sokolova, M., & Lapalme, G. (2009). A systematic analysis of performance
measures for classification tasks. Information Processing & Management,
45(4), 427–437. \doi{10.1016/j.ipm.2009.03.002}

Wickham H, Cheng J, Jacobs A, Aden-Buie G, Schloerke B (2025). \emph{ellmer: Chat
with Large Language Models}. R package. \url{https://github.com/tidyverse/ellmer}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://quallmer.github.io/quallmer/}
}

}
\author{
\strong{Maintainer}: Seraphine F. Maerz \email{seraphine.maerz@unimelb.edu.au} (\href{https://orcid.org/0000-0002-7173-9617}{ORCID})

Authors:
\itemize{
  \item Kenneth Benoit \email{kbenoit@smu.edu.sg} (\href{https://orcid.org/0000-0002-0797-564X}{ORCID})
}

}
\keyword{internal}
