% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{cluster_summary}
\alias{cluster_summary}
\title{Cluster-wise summary table using a separate cluster vector (gtsummary + gt)}
\usage{
cluster_summary(
  data,
  clusters,
  add_options = list(add_overall = FALSE, add_n = TRUE, add_p = FALSE),
  return_as = c("gtsummary", "gt"),
  include = NULL,
  ...
)
}
\arguments{
\item{data}{A data.frame or tibble of features to summarize.}

\item{clusters}{A vector (factor, character, or numeric) of cluster labels
with length equal to \code{nrow(data)}.}

\item{add_options}{List of post-processing options:
\itemize{
\item \code{add_overall} (default \code{FALSE}): add overall column
\item \code{add_n}       (default \code{TRUE}) : add group Ns
\item \code{add_p}       (default \code{FALSE}): add p-values
}}

\item{return_as}{\code{"gtsummary"} (default) or \code{"gt"}. When \code{"gt"}, the function
calls \code{\link[gtsummary:as_gt]{gtsummary::as_gt()}} for rendering.}

\item{include}{Optional character vector of variables to include.
Defaults to all columns in \code{data}.}

\item{...}{Passed to \code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}} (e.g., \verb{statistic=},
\verb{type=}, \verb{digits=}, \verb{missing=}, \verb{label=}, etc.).}
}
\value{
A \code{gtsummary::tbl_summary} (default) or \code{gt::gt_tbl} if \code{return_as="gt"}.
}
\description{
Produce a cluster-stratified summary table using \strong{gtsummary}, where the
cluster assignments are supplied as a separate vector.
All additional arguments (\code{...}) are passed directly to
\code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}}, so users can specify
\code{all_continuous()} / \code{all_categorical()} selectors and custom statistics.
}
\examples{
if(requireNamespace("gtsummary")){
df <- data.frame(
  age = rnorm(100, 60, 10),
  bmi = rnorm(100, 28, 5),
  sex = sample(c("F","M"), 100, TRUE)
)
cl <- sample(1:3, 100, TRUE)

cluster_summary(
  data = df,
  clusters = cl,
  statistic = list(
    gtsummary::all_continuous()  ~ "{mean} ({sd})",
    gtsummary::all_categorical() ~ "{n} / {N} ({p}\%)"
  ),
  missing = "always"
)
}

}
