% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{a549_dex_downreg}
\alias{a549_dex_downreg}
\title{A549 Downregulated Genes (Dex)}
\format{
A character vector of length 15, containing HGNC gene symbols.
}
\source{
Supplementary Table S3 from Tav \emph{et al.} (2023).
}
\usage{
a549_dex_downreg
}
\description{
Example gene set of downregulated (repressed) genes in A549 cells after
dexamethasone treatment. To keep the dataset small and suitable for examples
and tests, only the first 15 downregulated gene symbols are included here.
}
\details{
The full list of differentially expressed genes (activated and repressed) is
provided as Supplementary Table S3 in Tav \emph{et al.} (2023). The raw Excel
file can be downloaded directly from \emph{Frontiers in Genetics}:
\url{https://www.frontiersin.org/api/v4/articles/1237092/file/Table_3.XLSX/1237092_supplementary-materials_tables_3_xlsx/1}.

In this package, we subset the data to only the first 15 repressed genes,
which are stored in the object \code{a549_dex_downreg}.
}
\examples{
# Load dataset
data(a549_dex_downreg)
a549_dex_downreg
}
\references{
Tav C, Fournier É, Fournier M, Khadangi F, Baguette A, Côté MC, Silveira MAD,
Bérubé-Simard F-A, Bourque G, Droit A, Bilodeau S (2023).
"Glucocorticoid stimulation induces regionalized gene responses within
topologically associating domains." \emph{Frontiers in Genetics}.
\doi{10.3389/fgene.2023.1237092}
}
\keyword{datasets}
