% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.operators.R
\name{matern2d.operators}
\alias{matern2d.operators}
\title{Rational approximations of stationary anisotropic Gaussian Matern random fields}
\usage{
matern2d.operators(
  hx = NULL,
  hy = NULL,
  hxy = NULL,
  nu = NULL,
  sigma = NULL,
  mesh = NULL,
  fem = NULL,
  m = 1,
  type_rational_approximation = c("brasil", "chebfun", "chebfunLB"),
  return_fem_matrices = FALSE
)
}
\arguments{
\item{hx}{Parameter in the H matrix.}

\item{hy}{Parameter in the H matrix.}

\item{hxy}{Parameter in the H matrix.}

\item{nu}{Smoothness parameter.}

\item{sigma}{standard deviation parameter.}

\item{mesh}{An \code{fmesher} mesh.}

\item{fem}{Optional precomputed FEM matrices.}

\item{m}{The order of the rational approximation, which needs to be a
positive integer. The default value is 1.}

\item{type_rational_approximation}{Which type of rational
approximation should be used? The current types are
"brasil", "chebfun" or "chebfunLB".}

\item{return_fem_matrices}{Should the FEM matrices be returned?}
}
\value{
An object of type \code{CBrSPDEobj2d}
}
\description{
\code{matern2d.operators} is used for computing a rational SPDE approximation
of a stationary Gaussian random fields on \eqn{R^d} with a Matern covariance
function
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}(\sqrt{h^T H^{-1}h})^\nu K_\nu(\sqrt{h^T H^{-1}h})},
based on a SPDE representation of the form
\deqn{(I - \nabla\cdot(H\nabla))^{(\nu+1)/2}u = c\sigma W},
where $c>0$ is a constant. The matrix \eqn{H} is defined as
\deqn{\begin{bmatrix}
h_x^2 & h_xh_yh_{xy} \\
h_xh_yh_{xy} & h_y^2
\end{bmatrix}}
}
\examples{
library(fmesher)
n_loc <- 2000
loc_2d_mesh <- matrix(runif(n_loc * 2), n_loc, 2)
mesh_2d <- fm_mesh_2d(loc = loc_2d_mesh, cutoff = 0.03, max.edge = c(0.1, 0.5))
op <- matern2d.operators(mesh = mesh_2d)
}
\seealso{
\code{\link[=fractional.operators]{fractional.operators()}},
\code{\link[=spde.matern.operators]{spde.matern.operators()}},
\code{\link[=matern.operators]{matern.operators()}}
}
