% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factory.R
\name{makeflow}
\alias{makeflow}
\title{Flow Factory}
\usage{
makeflow(flowtype, params = list())
}
\arguments{
\item{flowtype}{Character string specifying the flow type.}

\item{params}{A named list of parameters required by the chosen flow.}
}
\value{
A flow model object with methods:
\itemize{
\item sampleq(n)
\item logq(z0)
\item applyflow(z0)
}
}
\description{
A unified constructor for all flow models in the rareflow package.
This function dispatches to the appropriate flow implementation
based on the \code{flowtype} argument.
}
\details{
Supported flow types:
\itemize{
\item "planar"       -> planarflowmodel()
\item "radial"       -> radialflowmodel()
\item "maf"          -> mafflowmodel()
\item "splinepwlin"  -> splinepwlinflowmodel()
}
}
\examples{
# Create a planar flow
f <- makeflow("planar", list(u = 0.1, w = 0.2, b = 0))
s <- f$sampleq(10)

# Create a 2D spline flow
f2 <- makeflow("splinepwlin", list(d = 2, K = 8))

}
