% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rblimp_sim.R
\name{SIMULATE}
\alias{SIMULATE}
\title{Create a SIMULATE specification for use in rblimp()}
\usage{
SIMULATE(model, n, define = NULL, variables = NULL)
}
\arguments{
\item{model}{Character string or vector specifying data generation equations.
Same format as \code{\link[=rblimp_sim]{rblimp_sim()}}.}

\item{n}{Sample size. For single-level: integer. For multilevel: named list.}

\item{define}{Character vector or string of parameter definitions (optional).}

\item{variables}{Formula or character string specifying which variables to save (optional).}
}
\value{
A \code{blimp_simulate} object (subclass of \code{blimp_syntax}) that can be passed to
\code{rblimp()} as the \code{data} argument.
}
\description{
Creates a simulation specification that can be passed to \code{rblimp()} as the \code{data} argument.
Instead of reading existing data, \code{rblimp()} will use Blimp's SIMULATE command to generate
data and then fit the specified model to it.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Create simulation specification
sim_spec <- SIMULATE(
  model = c(
    "x = normal(0, 1)",
    "y = normal(10 + x*0.5, 1)"
  ),
  n = 1000
)

# View the specification
print(sim_spec)

# Use in rblimp to fit a model to simulated data
mdl <- rblimp(
  model = "y ~ x",
  data = sim_spec,
  seed = 123,
  burn = 5000,
  iter = 5000
)

summary(mdl)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=rblimp_sim]{rblimp_sim()}} for directly generating simulated data without fitting a model
}
