\name{rcd3}
\alias{rcd3}
\title{Efficient Row-Column Designs for 3-Level Factorial Experiments in 3 Rows}
\description{
Constructs efficient row-column designs for 3-level factorial experiments with 3 rows. The designs ensure the estimation of all main effects (full efficiency) and two-factor interactions in minimum replications.
}
\usage{
rcd3(n_factors = 3, show_efficiency = TRUE, show_replications = TRUE, verbose = TRUE)
}
\arguments{
  \item{n_factors}{Number of factors in the experiment (integer >= 2). Each factor has 3 levels.}
  \item{show_efficiency}{Logical; if TRUE, prints efficiency factors for all main effects and two-factor interactions. Default is TRUE.}
  \item{show_replications}{Logical; if TRUE, prints full replications in row-column format preserving the original row/column labels. Default is TRUE.}
  \item{verbose}{Logical; if TRUE, displays progress messages and block tables using \code{message()}. Default is TRUE.}
}
\details{
Generates efficient row-column designs of 3-level factorial experiments in 3 rows, enabling estimation of all main effects (full efficiency) and two-factor interactions in minimum number of replications. Progress messages and principal block tables are displayed if \code{verbose = TRUE}.
}
\value{
A list with the following components:
\describe{
  \item{factors}{Vector of factor names.}
  \item{normalized_effects}{Matrix of normalized main effects and two-factor interactions.}
  \item{effect_labels}{Vector of effect labels corresponding to normalized effects.}
  \item{chosen_principal_blocks}{List of selected principal blocks (matrices).}
  \item{efficiency_factors}{Named vector of efficiency factors for all main effects and two-factor interactions (if show_efficiency = TRUE).}
  \item{replications}{Nested list of full replications; final row-column design for a given number of factors.}
}
}
\references{
Dey, A., & Mukerjee, R. (2012). Some results on optimal block designs for 3-level factorial experiments. \emph{Statistics & Probability Letters}, 82(6), 1202–1208. \doi{10.1016/j.spl.2012.06.014}

Dash, S., Parsad, R., & Gupta, V. K. (2013). Efficient block designs for 3-level factorial experiments. \emph{J. Stat. Theory Pract.}, 7(3), 369–383. \doi{10.1007/s40003-013-0059-5}
}
\examples{
rcd3(n_factors = 3, show_efficiency = TRUE, show_replications = TRUE, verbose = TRUE)
rcd3(n_factors = 2, show_efficiency = TRUE, show_replications = FALSE, verbose = TRUE)
quiet_result <- rcd3(n_factors = 4, verbose = FALSE)
result <- rcd3(n_factors = 4)
str(result$chosen_principal_blocks)
str(result$replications)
}
\seealso{
\code{\link{expand.grid}}, \code{\link{message}}, \code{\link{print}}
}
\author{
Sunil Kumar Yadav [aut], Sukanta Dash [aut, cre] <sukanta.iasri@gmail.com>
}
\keyword{design factorial block row-column efficiency}
