% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props.R
\name{remove.property}
\alias{remove.property}
\title{Remove a property associated with a molecule.}
\usage{
remove.property(molecule, key)
}
\arguments{
\item{molecule}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}

\item{key}{The property key as a character string}
}
\description{
In this context a property is a value associated with a key and stored
with the molecule. This method will remove the property defined by the key.
If there is such key, a warning is raised.
}
\examples{
mol <- parse.smiles("CC1CC(C=O)CCC1")[[1]]
set.property(mol, 'prop1', 23.45)
set.property(mol, 'prop2', 'inactive')
get.properties(mol)
remove.property(mol, 'prop2')
get.properties(mol)
}
\seealso{
\code{\link{set.property}}, \code{\link{get.property}}, \code{\link{get.properties}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
