# fmt: skip file
## This file was created automatically, do not edit by hand.
#' Evaluate expressions
#'
#' This module arithmetically processes every timestep of the input dataset. Each individual assignment statement have to end with a semi-colon. The special key _ALL_ is used as a template. A statement with a template is replaced for all variable names. Unlike regular variables, temporary variables are never written to the output stream. To define a temporary variable simply prefix the variable name with an underscore (e.g. _varname) when the variable is declared.  The following operators are supported:  Operator   &amp; Meaning             &amp; Example   &amp; Result =      &amp; assignment          &amp; x = y     &amp; Assigns y to x +      &amp; addition            &amp; x + y     &amp; Sum of x and y -      &amp; subtraction         &amp; x - y     &amp; Difference of x and y *      &amp; multiplication      &amp; x * y     &amp; Product of x and y /      &amp; division            &amp; x / y     &amp; Quotient of x and y ^      &amp; exponentiation      &amp; x ^y      &amp; Exponentiates x with y ==     &amp; equal to            &amp; x == y    &amp;  1, if x equal to y; else 0 !=     &amp; not equal to        &amp; x != y    &amp;  1, if x not equal to y; else 0 &gt;      &amp; greater than        &amp; x &gt; y     &amp;  1, if x greater than y; else 0 &lt;      &amp; less than           &amp; x &lt; y     &amp;  1, if x less than y; else 0 &gt;=     &amp; greater equal       &amp; x &gt;= y    &amp;  1, if x greater equal y; else 0 &lt;=     &amp; less equal          &amp; x &lt;= y    &amp;  1, if x less equal y; else 0 &lt;=&gt;    &amp; less equal greater  &amp; x &lt;=&gt; y   &amp; -1, if x less y; 1, if x greater y; else 0 &amp;&amp;     &amp; logical AND         &amp; x &amp;&amp; y    &amp;  1, if x and y not equal 0; else 0 ||     &amp; logical OR          &amp; x || y    &amp;  1, if x or y not equal 0; else 0 !      &amp; logical NOT         &amp; !x        &amp;  1, if x equal 0; else 0 ?:     &amp; ternary conditional &amp; x ? y : z &amp; y, if x not equal 0, else z  The following functions are supported:  Math intrinsics:  abs(x)      &quot;    &quot;    Absolute value of x floor(x)    &quot;    &quot;    Round to largest integral value not greater than x ceil(x)     &quot;    &quot;    Round to smallest integral value not less than x float(x)    &quot;    &quot;    32-bit float value of x int(x)      &quot;    &quot;    Integer value of x nint(x)     &quot;    &quot;    Nearest integer value of x sqr(x)      &quot;    &quot;    Square of x sqrt(x)     &quot;    &quot;    Square Root of x exp(x)      &quot;    &quot;    Exponential of x ln(x)       &quot;    &quot;    Natural logarithm of x log10(x)    &quot;    &quot;    Base 10 logarithm of x sin(x)      &quot;    &quot;    Sine of x, where x is specified in radians cos(x)      &quot;    &quot;    Cosine of x, where x is specified in radians tan(x)      &quot;    &quot;    Tangent of x, where x is specified in radians asin(x)     &quot;    &quot;    Arc-sine of x, where x is specified in radians acos(x)     &quot;    &quot;    Arc-cosine of x, where x is specified in radians atan(x)     &quot;    &quot;    Arc-tangent of x, where x is specified in radians sinh(x)     &quot;    &quot;    Hyperbolic sine of x, where x is specified in radians cosh(x)     &quot;    &quot;    Hyperbolic cosine of x, where x is specified in radians tanh(x)     &quot;    &quot;    Hyperbolic tangent of x, where x is specified in radians asinh(x)    &quot;    &quot;    Inverse hyperbolic sine of x, where x is specified in radians acosh(x)    &quot;    &quot;    Inverse hyperbolic cosine of x, where x is specified in radians atanh(x)    &quot;    &quot;    Inverse hyperbolic tangent of x, where x is specified in radians rad(x)      &quot;    &quot;    Convert x from degrees to radians deg(x)      &quot;    &quot;    Convert x from radians to degrees rand(x)     &quot;    &quot;    Replace x by pseudo-random numbers in the range of 0 to 1 isMissval(x)&quot;    &quot;    Returns 1 where x is missing  mod(x,y)    &quot;    &quot;    Floating-point remainder of x/ y min(x,y)    &quot;    &quot;    Minimum value of x and y max(x,y)    &quot;    &quot;    Maximum value of x and y pow(x,y)    &quot;    &quot;    Power function hypot(x,y)  &quot;    &quot;    Euclidean distance function, sqrt(x*x + y*y) atan2(x,y)  &quot;    &quot;    Arc tangent function of y/x, using signs to determine quadrants  Coordinates:  clon(x)      &quot;    &quot;    Longitude coordinate of x (available only if x has geographical coordinates) clat(x)      &quot;    &quot;    Latitude coordinate of x (available only if x has geographical coordinates) gridarea(x)  &quot;    &quot;    Grid cell area of x (available only if x has geographical coordinates) gridindex(x) &quot;    &quot;    Grid cell indices of x clev(x)      &quot;    &quot;    Level coordinate of x (0, if x is a 2D surface variable) clevidx(x)   &quot;    &quot;    Level index of x (0, if x is a 2D surface variable) cthickness(x)&quot;    &quot;    Layer thickness, upper minus lower level bound of x (1, if level bounds are missing) ctimestep()  &quot;    &quot;    Timestep number (1 to N) cdate()      &quot;    &quot;    Verification date as YYYYMMDD ctime()      &quot;    &quot;    Verification time as HHMMSS.millisecond cdeltat()    &quot;    &quot;    Difference between current and last timestep in seconds cday()       &quot;    &quot;    Day as DD cmonth()     &quot;    &quot;    Month as MM cyear()      &quot;    &quot;    Year as YYYY csecond()    &quot;    &quot;    Second as SS.millisecond cminute()    &quot;    &quot;    Minute as MM chour()      &quot;    &quot;    Hour as HH  Constants:  ngp(x)    &quot;    &quot;    Number of horizontal grid points nlev(x)   &quot;    &quot;    Number of vertical levels size(x)   &quot;    &quot;    Total number of elements (ngp(x)*nlev(x)) missval(x)&quot;    &quot;    Returns the missing value of variable x  Statistics over a field:  fldmin(x), fldmax(x), fldrange(x), fldsum(x), fldmean(x), fldavg(x), fldstd(x), fldstd1(x), fldvar(x), fldvar1(x), fldskew(x), fldkurt(x), fldmedian(x)  Zonal statistics for regular 2D grids:  zonmin(x), zonmax(x), zonrange(x), zonsum(x), zonmean(x), zonavg(x), zonstd(x), zonstd1(x), zonvar(x), zonvar1(x), zonskew(x), zonkurt(x), zonmedian(x)  Vertical statistics:  vertmin(x), vertmax(x), vertrange(x), vertsum(x), vertmean(x), vertavg(x), vertstd(x), vertstd1(x), vertvar(x), vertvar1(x)  Miscellaneous:  sellevel(x,k)          &quot;    &quot;    Select level k of variable x sellevidx(x,k)         &quot;    &quot;    Select level index k of variable x sellevelrange(x,k1,k2) &quot;    &quot;    Select all levels of variable x in the range k1 to k2 sellevidxrange(x,k1,k2)&quot;    &quot;    Select all level indices of variable x in the range k1 to k2 remove(x)              &quot;    &quot;    Remove variable x from output stream  
#'
#' @details
#'     expr    Evaluate expressions
#'             The processing instructions are read from the parameter.
#'     exprf   Evaluate expressions script
#'             Contrary to expr the processing instructions are read from a file.
#'     aexpr   Evaluate expressions and append results
#'             Same as expr, but keep input variables and append results
#'     aexprf  Evaluate expression script and append results
#'             Same as exprf, but keep input variables and append results
#' 
#'
#' @section Note: 
#' If the input stream contains duplicate entries of the same variable name then the last one is used.
#'
#' @returns
#' Operators that output one or more files return a character vector to the
#' output files.
#'
#' Operators that output an indefinite number of files return a string with the
#' basename of the files.
#'
#' Operators that don't return filenames return a character vector with the
#' string output.
#' @name expr
NULL
